"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregationType = exports.ExpressionRow = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _alertingComparators = require("@kbn/alerting-comparators");
var _common = require("@kbn/observability-plugin/common");
var _metrics = require("../../../../common/alerting/metrics");
var _metrics_source = require("../../../containers/metrics_source");
var _corrected_percent_convert = require("../../../../common/utils/corrected_percent_convert");
var _types = require("../types");
var _custom_equation = require("./custom_equation");
var _i18n_strings = require("../i18n_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/metric_threshold/components/expression_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NegativeHorizontalMarginDiv = _styled.default.div`
  margin: 0 -4px;
`;
const StyledExpression = _styled.default.div`
  padding: 0 4px;
`;
const StyledHealth = (0, _styled.default)(_eui.EuiHealth)`
  margin-left: 4px;
`;
const ExpressionRow = ({
  children,
  setRuleParams,
  expression,
  errors,
  expressionId,
  remove,
  canDelete
}) => {
  var _ref, _ref2, _metricsView$fields;
  const [isExpanded, toggle] = (0, _useToggle.default)(true);
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    aggType = _types.AGGREGATION_TYPES.MAX,
    metric,
    comparator = _alertingComparators.COMPARATORS.GREATER_THAN,
    threshold = [],
    warningThreshold = [],
    warningComparator
  } = expression;
  const [displayWarningThreshold, setDisplayWarningThreshold] = (0, _react.useState)(Boolean(warningThreshold === null || warningThreshold === void 0 ? void 0 : warningThreshold.length));
  const isMetricPct = (0, _react.useMemo)(() => Boolean(metric && metric.endsWith('.pct')), [metric]);
  const updateAggType = (0, _react.useCallback)(at => {
    setRuleParams(expressionId, {
      ...expression,
      aggType: at,
      metric: ['custom', 'count'].includes(at) ? undefined : expression.metric,
      customMetrics: at === 'custom' ? expression.customMetrics : undefined,
      equation: at === 'custom' ? expression.equation : undefined,
      label: at === 'custom' ? expression.label : undefined
    });
  }, [expressionId, expression, setRuleParams]);
  const updateMetric = (0, _react.useCallback)(m => {
    setRuleParams(expressionId, {
      ...expression,
      metric: m
    });
  }, [expressionId, expression, setRuleParams]);
  const updateComparator = (0, _react.useCallback)(c => {
    setRuleParams(expressionId, {
      ...expression,
      comparator: c
    });
  }, [expressionId, expression, setRuleParams]);
  const updateWarningComparator = (0, _react.useCallback)(c => {
    setRuleParams(expressionId, {
      ...expression,
      warningComparator: c
    });
  }, [expressionId, expression, setRuleParams]);
  const convertThreshold = (0, _react.useCallback)(enteredThreshold => isMetricPct ? enteredThreshold.map(v => (0, _corrected_percent_convert.pctToDecimal)(v)) : enteredThreshold, [isMetricPct]);
  const updateThreshold = (0, _react.useCallback)(enteredThreshold => {
    const t = convertThreshold(enteredThreshold);
    if (t.join() !== expression.threshold.join()) {
      setRuleParams(expressionId, {
        ...expression,
        threshold: t
      });
    }
  }, [expressionId, expression, convertThreshold, setRuleParams]);
  const updateWarningThreshold = (0, _react.useCallback)(enteredThreshold => {
    var _expression$warningTh;
    const t = convertThreshold(enteredThreshold);
    if (t.join() !== ((_expression$warningTh = expression.warningThreshold) === null || _expression$warningTh === void 0 ? void 0 : _expression$warningTh.join())) {
      setRuleParams(expressionId, {
        ...expression,
        warningThreshold: t
      });
    }
  }, [expressionId, expression, convertThreshold, setRuleParams]);
  const toggleWarningThreshold = (0, _react.useCallback)(() => {
    if (!displayWarningThreshold) {
      setDisplayWarningThreshold(true);
      setRuleParams(expressionId, {
        ...expression,
        warningComparator: comparator,
        warningThreshold: []
      });
    } else {
      setDisplayWarningThreshold(false);
      setRuleParams(expressionId, (0, _lodash.omit)(expression, 'warningComparator', 'warningThreshold'));
    }
  }, [displayWarningThreshold, setDisplayWarningThreshold, setRuleParams, comparator, expression, expressionId]);
  const handleCustomMetricChange = (0, _react.useCallback)(exp => {
    setRuleParams(expressionId, exp);
  }, [expressionId, setRuleParams]);
  const criticalThresholdExpression = /*#__PURE__*/_react.default.createElement(ThresholdElement, {
    comparator: comparator,
    threshold: threshold,
    updateComparator: updateComparator,
    updateThreshold: updateThreshold,
    errors: (_ref = errors.critical) !== null && _ref !== void 0 ? _ref : {},
    isMetricPct: isMetricPct,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 5
    }
  });
  const warningThresholdExpression = displayWarningThreshold && /*#__PURE__*/_react.default.createElement(ThresholdElement, {
    comparator: warningComparator || comparator,
    threshold: warningThreshold,
    updateComparator: updateWarningComparator,
    updateThreshold: updateWarningThreshold,
    errors: (_ref2 = errors.warning) !== null && _ref2 !== void 0 ? _ref2 : {},
    isMetricPct: isMetricPct,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  });
  const normalizedFields = ((_metricsView$fields = metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields) !== null && _metricsView$fields !== void 0 ? _metricsView$fields : []).map(f => ({
    normalizedType: f.type,
    name: f.name
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": "metricThresholdExpressionRow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    onClick: toggle,
    "data-test-subj": "expandRow",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expandRowLabel', {
      defaultMessage: 'Expand row.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: NegativeHorizontalMarginDiv,
    gutterSize: aggType !== 'custom' ? 'l' : 'm',
    alignItems: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StyledExpression, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_public.WhenExpression, {
    customAggTypesOptions: aggregationType,
    aggType: aggType,
    onChangeSelectedAggType: updateAggType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  })), !['count', 'custom'].includes(aggType) && /*#__PURE__*/_react.default.createElement(StyledExpression, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_public.OfExpression, {
    customAggTypesOptions: aggregationType,
    aggField: metric,
    fields: normalizedFields,
    aggType: aggType,
    errors: errors,
    onChangeSelectedAggField: updateMetric,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.alertFlyout.ofExpression.helpTextDetail",
      defaultMessage: "Can't find a metric? {documentationLink}.",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraExpressionRowLearnHowToAddMoreDataLink",
          href: "https://www.elastic.co/guide/en/observability/current/configure-settings.html",
          target: "BLANK",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.metrics.alertFlyout.ofExpression.popoverLinkLabel",
          defaultMessage: "Learn how to add more data",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 251,
            columnNumber: 29
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 21
      }
    }),
    "data-test-subj": "ofExpression",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 17
    }
  })), !displayWarningThreshold && criticalThresholdExpression, !displayWarningThreshold && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: NegativeHorizontalMarginDiv,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraExpressionRowAddWarningThresholdButton",
    color: 'primary',
    flush: 'left',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: toggleWarningThreshold,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.addWarningThreshold",
    defaultMessage: "Add warning threshold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 21
    }
  }))))), displayWarningThreshold && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: NegativeHorizontalMarginDiv,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 15
    }
  }, criticalThresholdExpression, /*#__PURE__*/_react.default.createElement(StyledHealth, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.criticalThreshold",
    defaultMessage: "Alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: NegativeHorizontalMarginDiv,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 15
    }
  }, warningThresholdExpression, /*#__PURE__*/_react.default.createElement(StyledHealth, {
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.warningThreshold",
    defaultMessage: "Warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraExpressionRowButton",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.removeWarningThreshold', {
      defaultMessage: 'Remove warningThreshold'
    }),
    iconSize: "s",
    color: "text",
    iconType: 'minusInCircleFilled',
    onClick: toggleWarningThreshold,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 17
    }
  }))), aggType === _metrics.Aggregators.CUSTOM && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: NegativeHorizontalMarginDiv,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_equation.CustomEquationEditor, {
    expression: expression,
    fields: normalizedFields,
    aggregationTypes: aggregationType,
    onChange: handleCustomMetricChange,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 15
    }
  }))), canDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraExpressionRowButton",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.removeCondition', {
      defaultMessage: 'Remove condition'
    }),
    color: 'danger',
    iconType: 'trash',
    onClick: () => remove(expressionId),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 13
    }
  }))), isExpanded ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: '0 0 0 28px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 21
    }
  }, children) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 7
    }
  }));
};
exports.ExpressionRow = ExpressionRow;
const ThresholdElement = ({
  updateComparator,
  updateThreshold,
  threshold,
  isMetricPct,
  comparator,
  errors
}) => {
  const displayedThreshold = (0, _react.useMemo)(() => {
    if (isMetricPct) return threshold.map(v => (0, _corrected_percent_convert.decimalToPct)(v));
    return threshold;
  }, [threshold, isMetricPct]);
  const thresholdComparator = (0, _react.useCallback)(() => {
    if (!comparator) return _alertingComparators.COMPARATORS.GREATER_THAN;
    // Check if the rule had the legacy OUTSIDE_RANGE inside its params.
    // Then, change it on-the-fly to NOT_BETWEEN
    return (0, _common.convertToBuiltInComparators)(comparator);
  }, [comparator]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledExpression, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ThresholdExpression, {
    thresholdComparator: thresholdComparator(),
    threshold: displayedThreshold,
    onChangeSelectedThresholdComparator: updateComparator,
    onChangeSelectedThreshold: updateThreshold,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 9
    }
  })), isMetricPct && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      alignSelf: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 11
    }
  }, "%")));
};
const aggregationType = exports.aggregationType = {
  avg: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.avg', {
      defaultMessage: 'Average'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'histogram'],
    value: _types.AGGREGATION_TYPES.AVERAGE
  },
  max: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.max', {
      defaultMessage: 'Max'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'date', 'histogram'],
    value: _types.AGGREGATION_TYPES.MAX
  },
  min: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.min', {
      defaultMessage: 'Min'
    }),
    fieldRequired: true,
    validNormalizedTypes: ['number', 'date', 'histogram'],
    value: _types.AGGREGATION_TYPES.MIN
  },
  cardinality: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.cardinality', {
      defaultMessage: 'Cardinality'
    }),
    fieldRequired: false,
    value: _types.AGGREGATION_TYPES.CARDINALITY,
    validNormalizedTypes: ['number', 'string', 'ip', 'date']
  },
  rate: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.rate', {
      defaultMessage: 'Rate'
    }),
    fieldRequired: false,
    value: _types.AGGREGATION_TYPES.RATE,
    validNormalizedTypes: ['number']
  },
  count: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.count', {
      defaultMessage: 'Document count'
    }),
    fieldRequired: false,
    value: _types.AGGREGATION_TYPES.COUNT,
    validNormalizedTypes: ['number']
  },
  sum: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.sum', {
      defaultMessage: 'Sum'
    }),
    fieldRequired: false,
    value: _types.AGGREGATION_TYPES.SUM,
    validNormalizedTypes: ['number', 'histogram']
  },
  p95: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.p95', {
      defaultMessage: '95th Percentile'
    }),
    fieldRequired: false,
    value: _types.AGGREGATION_TYPES.P95,
    validNormalizedTypes: ['number', 'histogram']
  },
  p99: {
    text: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.aggregationText.p99', {
      defaultMessage: '99th Percentile'
    }),
    fieldRequired: false,
    value: _types.AGGREGATION_TYPES.P99,
    validNormalizedTypes: ['number', 'histogram']
  },
  custom: {
    text: _i18n_strings.CUSTOM_EQUATION,
    fieldRequired: false,
    value: _types.AGGREGATION_TYPES.CUSTOM,
    validNormalizedTypes: ['number', 'histogram']
  }
};