"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestDocumentation = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _prompts = require("./prompts");
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requestDocumentation = ({
  outputApi,
  esqlPrompts,
  messages,
  connectorId,
  functionCalling,
  maxRetries,
  retryConfiguration,
  metadata,
  toolOptions
}) => {
  return outputApi({
    id: 'request_documentation',
    connectorId,
    stream: true,
    functionCalling,
    maxRetries,
    retryConfiguration,
    metadata,
    system: (0, _prompts.requestDocumentationSystemPrompt)({
      esqlPrompts
    }),
    previousMessages: messages,
    input: `Now, based on the previous conversation, request documentation
        from the ES|QL handbook to help you get the right information
        needed to generate a query.

        Examples for functions and commands:
        - Do you need to group data? Request \`STATS\`.
        - Extract data? Request \`DISSECT\` AND \`GROK\`.
        - Convert a column based on a set of conditionals? Request \`EVAL\` and \`CASE\`.
`,
    schema: _shared.requestDocumentationSchema
  }).pipe((0, _inferenceCommon.withoutOutputUpdateEvents)());
};
exports.requestDocumentation = requestDocumentation;