"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceFieldSelects = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lib = require("../../../lib");
var _mappings_state_context = require("../../../mappings_state_context");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/reference_field_selects.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ReferenceFieldSelects = () => {
  const {
    fields,
    mappingViewFields
  } = (0, _mappings_state_context.useMappingsState)();
  const allFields = {
    byId: {
      ...mappingViewFields.byId,
      ...fields.byId
    },
    rootLevelFields: [],
    aliases: {},
    maxNestedDepth: 0
  };
  const referenceFieldOptions = Object.values(allFields.byId).filter(field => field.source.type === 'text' && !field.isMultiField).map(field => ({
    value: field.path.join('.'),
    inputDisplay: field.path.join('.'),
    'data-test-subj': `select-reference-field-${field.path.join('.')}}`
  }));
  const fieldConfigReferenceField = (0, _lib.getFieldConfig)('reference_field');
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "reference_field",
    config: fieldConfigReferenceField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, field => /*#__PURE__*/_react.default.createElement(_shared_imports.SuperSelectField, {
    field: field,
    euiFieldProps: {
      options: referenceFieldOptions
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.referenceField.optionalLabel', {
      defaultMessage: 'Optional'
    })),
    "data-test-subj": "referenceFieldSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }));
};
exports.ReferenceFieldSelects = ReferenceFieldSelects;