"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dynamicSerializer = exports.dynamicDeserializer = exports.DynamicParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _edit_field = require("../fields/edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/dynamic_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Export custom serializer to be used when we need to serialize the form data to be sent to ES
 * @param field The field to be serialized
 */
const dynamicSerializer = field => {
  if (field.dynamic_toggle === undefined) {
    return field;
  }
  const dynamic = field.dynamic_toggle === true ? true : field.dynamic_strict === true ? 'strict' : false;
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    dynamic_toggle,
    dynamic_strict,
    ...rest
  } = field;
  return {
    ...rest,
    dynamic
  };
};

/**
 * Export custom deserializer to be used when we need to deserialize the data coming from ES
 * @param field The field to be serialized
 */
exports.dynamicSerializer = dynamicSerializer;
const dynamicDeserializer = field => {
  if (field.dynamic === undefined) {
    return field;
  }
  const dynamicToggleValue = field.dynamic === true;
  const dynamicStrictValue = field.dynamic === 'strict';
  return {
    ...field,
    dynamic_toggle: dynamicToggleValue,
    dynamic_strict: dynamicStrictValue
  };
};
exports.dynamicDeserializer = dynamicDeserializer;
const DynamicParameter = ({
  defaultToggleValue
}) => {
  return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicPropertyMappingParameter.fieldTitle', {
      defaultMessage: 'Dynamic property mapping'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicPropertyMappingParameter.fieldDescription', {
      defaultMessage: 'By default, properties can be added dynamically to objects within a document, just by indexing a document with the object containing the new property.'
    }),
    docLink: {
      text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicDocLinkText', {
        defaultMessage: 'Dynamic documentation'
      }),
      href: _documentation.documentationService.getDynamicLink()
    },
    formFieldPath: "dynamic_toggle",
    defaultToggleValue: defaultToggleValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, isOn => {
    return isOn === false ? /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "dynamic_strict",
      config: (0, _lib.getFieldConfig)('dynamic_strict'),
      component: _shared_imports.CheckBoxField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }) : null;
  });
};
exports.DynamicParameter = DynamicParameter;