"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getImageEmbeddableFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationUtil = require("@kbn/presentation-util");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _actions = require("../actions");
var _image_embeddable = require("../components/image_embeddable");
var _kibana_services = require("../services/kibana_services");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/image_embeddable/public/image_embeddable/get_image_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getImageEmbeddableFactory = ({
  embeddableEnhanced
}) => {
  const imageEmbeddableFactory = {
    type: _constants.IMAGE_EMBEDDABLE_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      var _dynamicActionsManage3;
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const dynamicActionsManager = embeddableEnhanced === null || embeddableEnhanced === void 0 ? void 0 : embeddableEnhanced.initializeEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), initialState);
      // if it is provided, start the dynamic actions manager
      const maybeStopDynamicActions = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.startDynamicActions();
      const filesClient = _kibana_services.filesService.filesClientFactory.asUnscoped();
      const imageConfig$ = new _rxjs.BehaviorSubject(initialState.rawState.imageConfig);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      function serializeState() {
        var _dynamicActionsManage;
        const {
          rawState: dynamicActionsState,
          references: dynamicActionsReferences
        } = (_dynamicActionsManage = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.serializeState()) !== null && _dynamicActionsManage !== void 0 ? _dynamicActionsManage : {};
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...dynamicActionsState,
            imageConfig: imageConfig$.getValue()
          },
          references: dynamicActionsReferences !== null && dynamicActionsReferences !== void 0 ? dynamicActionsReferences : []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, imageConfig$.pipe((0, _rxjs.map)(() => undefined))),
        getComparators: () => {
          var _dynamicActionsManage2;
          return {
            ...((_dynamicActionsManage2 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.comparators) !== null && _dynamicActionsManage2 !== void 0 ? _dynamicActionsManage2 : {
              enhancements: 'skip'
            }),
            ..._presentationPublishing.titleComparators,
            imageConfig: 'deepEquality'
          };
        },
        onReset: lastSaved => {
          var _lastSaved$rawState;
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.reinitializeState((_lastSaved$rawState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState) !== null && _lastSaved$rawState !== void 0 ? _lastSaved$rawState : {});
          if (lastSaved) imageConfig$.next(lastSaved.rawState.imageConfig);
        }
      });
      const embeddable = finalizeApi({
        ...titleManager.api,
        ...((_dynamicActionsManage3 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.api) !== null && _dynamicActionsManage3 !== void 0 ? _dynamicActionsManage3 : {}),
        ...unsavedChangesApi,
        dataLoading$,
        supportedTriggers: () => [_actions.IMAGE_CLICK_TRIGGER],
        onEdit: async () => {
          (0, _presentationUtil.openLazyFlyout)({
            core: _kibana_services.coreServices,
            parentApi,
            loadContent: async ({
              closeFlyout,
              ariaLabelledBy
            }) => {
              const {
                getImageEditor
              } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/image_editor/get_image_editor')));
              return await getImageEditor({
                closeFlyout,
                ariaLabelledBy,
                initialImageConfig: imageConfig$.getValue(),
                onSave: newImageConfig => {
                  imageConfig$.next(newImageConfig);
                }
              });
            }
          });
        },
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('imageEmbeddable.imageEmbeddableFactory.displayName.edit', {
          defaultMessage: 'image'
        }),
        serializeState
      });
      return {
        api: embeddable,
        Component: () => {
          const privateImageEmbeddableApi = (0, _react.useMemo)(() => {
            /** Memoize the API so that the reference stays consistent and it can be used as a dependency */
            return {
              ...embeddable,
              imageConfig$,
              setDataLoading: loading => dataLoading$.next(loading)
            };
          }, []);
          (0, _react.useEffect)(() => {
            return () => {
              // if it was started, stop the dynamic actions manager on unmount
              maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement(_image_embeddable.ImageEmbeddable, {
            api: privateImageEmbeddableApi,
            filesClient: filesClient,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 140,
              columnNumber: 13
            }
          });
        }
      };
    }
  };
  return imageEmbeddableFactory;
};
exports.getImageEmbeddableFactory = getImageEmbeddableFactory;