"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageEditorFlyout = ImageEditorFlyout;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _sharedUxFileUpload = require("@kbn/shared-ux-file-upload");
var _sharedUxFilePicker = require("@kbn/shared-ux-file-picker");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _imports = require("../../imports");
var _image_viewer = require("../image_viewer/image_viewer");
var _validate_image_config = require("../../utils/validate_image_config");
var _image_viewer_context = require("../image_viewer/image_viewer_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/image_embeddable/public/components/image_editor/image_editor_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// use eager version to avoid flickering
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Shared sizing css for image, upload placeholder, empty and not found state
 * Makes sure the container has not too large height to preserve vertical space for the image configuration in the flyout
 */
const CONTAINER_SIZING_CSS = (0, _react2.css)({
  aspectRatio: `21 / 9`,
  width: `100%`,
  height: `auto`,
  maxHeight: `max(20vh, 180px)`
});
function ImageEditorFlyout(props) {
  var _props$initialImageCo15;
  const isEditing = !!props.initialImageConfig;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    validateUrl
  } = (0, _image_viewer_context.useImageViewerContext)();
  const [fileId, setFileId] = (0, _react.useState)(() => {
    var _props$initialImageCo, _props$initialImageCo2;
    return ((_props$initialImageCo = props.initialImageConfig) === null || _props$initialImageCo === void 0 ? void 0 : (_props$initialImageCo2 = _props$initialImageCo.src) === null || _props$initialImageCo2 === void 0 ? void 0 : _props$initialImageCo2.type) === 'file' ? props.initialImageConfig.src.fileId : undefined;
  });
  const [fileImageMeta, setFileImageMeta] = (0, _react.useState)(() => {
    var _props$initialImageCo3, _props$initialImageCo4;
    return ((_props$initialImageCo3 = props.initialImageConfig) === null || _props$initialImageCo3 === void 0 ? void 0 : (_props$initialImageCo4 = _props$initialImageCo3.src) === null || _props$initialImageCo4 === void 0 ? void 0 : _props$initialImageCo4.type) === 'file' ? props.initialImageConfig.src.fileImageMeta : undefined;
  });
  const [srcType, setSrcType] = (0, _react.useState)(() => {
    var _props$initialImageCo5, _props$initialImageCo6, _props$initialImageCo7;
    return (_props$initialImageCo5 = (_props$initialImageCo6 = props.initialImageConfig) === null || _props$initialImageCo6 === void 0 ? void 0 : (_props$initialImageCo7 = _props$initialImageCo6.src) === null || _props$initialImageCo7 === void 0 ? void 0 : _props$initialImageCo7.type) !== null && _props$initialImageCo5 !== void 0 ? _props$initialImageCo5 : 'file';
  });
  const [srcUrl, setSrcUrl] = (0, _react.useState)(() => {
    var _props$initialImageCo8, _props$initialImageCo9;
    return ((_props$initialImageCo8 = props.initialImageConfig) === null || _props$initialImageCo8 === void 0 ? void 0 : (_props$initialImageCo9 = _props$initialImageCo8.src) === null || _props$initialImageCo9 === void 0 ? void 0 : _props$initialImageCo9.type) === 'url' ? props.initialImageConfig.src.url : '';
  });
  const [srcUrlError, setSrcUrlError] = (0, _react.useState)(() => {
    var _validateUrl$error, _validateUrl;
    if (srcUrl) return (_validateUrl$error = (_validateUrl = validateUrl(srcUrl)) === null || _validateUrl === void 0 ? void 0 : _validateUrl.error) !== null && _validateUrl$error !== void 0 ? _validateUrl$error : null;
    return null;
  });
  const [isFilePickerOpen, setIsFilePickerOpen] = (0, _react.useState)(false);
  const [sizingObjectFit, setSizingObjectFit] = (0, _react.useState)(() => {
    var _props$initialImageCo10, _props$initialImageCo11, _props$initialImageCo12;
    return (_props$initialImageCo10 = (_props$initialImageCo11 = props.initialImageConfig) === null || _props$initialImageCo11 === void 0 ? void 0 : (_props$initialImageCo12 = _props$initialImageCo11.sizing) === null || _props$initialImageCo12 === void 0 ? void 0 : _props$initialImageCo12.objectFit) !== null && _props$initialImageCo10 !== void 0 ? _props$initialImageCo10 : 'contain';
  });
  const [altText, setAltText] = (0, _react.useState)(() => {
    var _props$initialImageCo13, _props$initialImageCo14;
    return (_props$initialImageCo13 = (_props$initialImageCo14 = props.initialImageConfig) === null || _props$initialImageCo14 === void 0 ? void 0 : _props$initialImageCo14.altText) !== null && _props$initialImageCo13 !== void 0 ? _props$initialImageCo13 : '';
  });
  const [color, setColor, colorErrors] = (0, _eui.useColorPickerState)(props === null || props === void 0 ? void 0 : (_props$initialImageCo15 = props.initialImageConfig) === null || _props$initialImageCo15 === void 0 ? void 0 : _props$initialImageCo15.backgroundColor);
  const isColorInvalid = !!color && !!colorErrors;
  const draftImageConfig = {
    ...props.initialImageConfig,
    src: srcType === 'url' ? {
      type: 'url',
      url: srcUrl
    } : {
      type: 'file',
      fileId,
      fileImageMeta
    },
    altText,
    backgroundColor: colorErrors ? undefined : color,
    sizing: {
      objectFit: sizingObjectFit
    }
  };
  const isDraftImageConfigValid = (0, _validate_image_config.validateImageConfig)(draftImageConfig, {
    validateUrl
  });
  const onSave = () => {
    if (!isDraftImageConfigValid) return;
    props.onSave(draftImageConfig);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "createImageEmbeddableFlyout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: props.ariaLabelledBy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.editImagetitle",
    defaultMessage: "Edit image",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.addImagetitle",
    defaultMessage: "Add image",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    bottomBorder: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setSrcType('file'),
    isSelected: srcType === 'file',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.uploadTabLabel",
    defaultMessage: "Upload",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setSrcType('url'),
    isSelected: srcType === 'url',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.useLinkTabLabel",
    defaultMessage: "Use link",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }), srcType === 'file' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDraftImageConfigValid ? /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewer, {
    css: CONTAINER_SIZING_CSS,
    imageConfig: draftImageConfig,
    onChange: () => setIsFilePickerOpen(true),
    onClear: () => {
      setFileId(undefined);
      setFileImageMeta(undefined);
    },
    containerCSS: (0, _react2.css)`
                  border: ${euiTheme.border.thin};
                  background-color: ${euiTheme.colors.lightestShade};
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    css: (0, _react2.css)`
                  .lazy-load-fallback,
                  .euiFilePicker__prompt {
                    // increase upload image prompt size and lazy load fallback container to look nicer with large flyout and reduce layout shift
                    height: auto;
                    ${CONTAINER_SIZING_CSS};
                  }

                  .lazy-load-fallback {
                    display: flex;
                    justify-content: center;
                    align-items: center;
                  }
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxFileUpload.FileUpload, {
    kind: _imports.imageEmbeddableFileKind.id,
    onDone: files => {
      var _files$;
      return setFileId((_files$ = files[0]) === null || _files$ === void 0 ? void 0 : _files$.id);
    },
    immediate: true,
    initialPromptText: _i18n.i18n.translate('imageEmbeddable.imageEditor.uploadImagePromptText', {
      defaultMessage: 'Select or drag and drop an image'
    }),
    fullWidth: true,
    lazyLoadFallback: /*#__PURE__*/_react.default.createElement("div", {
      className: `lazy-load-fallback`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: 'xl',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 25
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    css: {
      textAlign: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setIsFilePickerOpen(true),
    "data-test-subj": "imageEmbeddableEditorSelectFiles",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.selectImagePromptText",
    defaultMessage: "Use a previously uploaded image",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 23
    }
  })))))), srcType === 'url' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isDraftImageConfigValid ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: (0, _react2.css)`
                  max-inline-size: none !important;
                `,
    iconType: "image",
    color: "subdued",
    title: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.byURLNoImageTitle",
      defaultMessage: "No Image",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 21
      }
    })),
    titleSize: 'xs',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewer, {
    css: CONTAINER_SIZING_CSS,
    imageConfig: draftImageConfig,
    onError: () => {
      setSrcUrlError(_i18n.i18n.translate('imageEmbeddable.imageEditor.urlFailedToLoadImageErrorMessage', {
        defaultMessage: 'Unable to load image.'
      }));
    },
    containerCSS: (0, _react2.css)`
                  border: ${euiTheme.border.thin};
                  background-color: ${euiTheme.colors.lightestShade};
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageURLInputLabel",
      defaultMessage: "Link to image",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 17
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageURLHelpText",
      defaultMessage: "Supported file types: png, jpeg, webp, and avif.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 17
      }
    }),
    fullWidth: true,
    isInvalid: !!srcUrlError,
    error: srcUrlError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    isInvalid: !!srcUrlError,
    "data-test-subj": 'imageEmbeddableEditorUrlInput',
    fullWidth: true,
    compressed: true,
    placeholder: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageURLPlaceholderText', {
      defaultMessage: 'Example: https://elastic.co/my-image.png'
    }),
    value: srcUrl,
    onChange: e => {
      const url = e.target.value;
      const {
        isValid,
        error
      } = validateUrl(url);
      if (!isValid) {
        setSrcUrlError(error);
      } else {
        setSrcUrlError(null);
      }
      setSrcUrl(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageFillModeLabel",
      defaultMessage: "Fill mode",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    fullWidth: true,
    options: [{
      value: 'contain',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeContainOptionText', {
        defaultMessage: 'Fit maintaining aspect ratio'
      })
    }, {
      value: 'cover',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeCoverOptionText', {
        defaultMessage: 'Fill maintaining aspect ratio'
      })
    }, {
      value: 'fill',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeFillOptionText', {
        defaultMessage: 'Stretch to fill'
      })
    }, {
      value: 'none',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeNoneOptionText', {
        defaultMessage: "Don't resize"
      })
    }],
    value: sizingObjectFit,
    onChange: e => setSizingObjectFit(e.target.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageBackgroundColorLabel",
      defaultMessage: "Background color",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 351,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    isInvalid: isColorInvalid,
    error: colorErrors,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    compressed: true,
    fullWidth: true,
    onChange: setColor,
    color: color,
    isInvalid: isColorInvalid,
    isClearable: true,
    placeholder: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageBackgroundColorPlaceholderText', {
      defaultMessage: 'Transparent'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageBackgroundDescriptionLabel",
      defaultMessage: "Description",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": 'imageEmbeddableEditorAltInput',
    fullWidth: true,
    compressed: true,
    value: altText,
    maxLength: 1000,
    placeholder: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageAltInputPlaceholderText', {
      defaultMessage: `Alt text that describes the image`
    }),
    onChange: e => {
      setAltText(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: props.onCancel,
    flush: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.imageBackgroundCloseButtonText",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    isDisabled: !isDraftImageConfigValid,
    "data-test-subj": "imageEmbeddableEditorSave",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.imageBackgroundSaveImageButtonText",
    defaultMessage: "Save",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 15
    }
  }))))), isFilePickerOpen && /*#__PURE__*/_react.default.createElement(_sharedUxFilePicker.FilePicker, {
    kind: _imports.imageEmbeddableFileKind.id,
    shouldAllowDelete: file => {
      var _file$user;
      return props.user ? props.user.profile_uid === ((_file$user = file.user) === null || _file$user === void 0 ? void 0 : _file$user.id) : false;
    },
    multiple: false,
    onClose: () => {
      setIsFilePickerOpen(false);
    },
    onDone: ([file]) => {
      setFileId(file.id);
      setFileImageMeta(file.meta);
      setIsFilePickerOpen(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 9
    }
  }));
}