"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSettingsContext = exports.useFieldSettingsContext = exports.SettingsContextProvider = exports.SettingsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _managementSettingsUtilities = require("@kbn/management-settings-utilities");
var _managementSettingsFieldDefinition = require("@kbn/management-settings-field-definition");
var _reactQuery = require("@kbn/react-query");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/contexts/settings_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Validation types

const SettingsContext = exports.SettingsContext = /*#__PURE__*/(0, _react.createContext)(null);
const useSettingsContext = () => {
  const context = (0, _react.useContext)(SettingsContext);
  if (!context) {
    throw new Error('useSettingsContext must be inside of a SettingsContextProvider.Provider.');
  }
  return context;
};
exports.useSettingsContext = useSettingsContext;
const SETTING_KEYS = [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR, _managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY, _managementSettingsIds.AI_ASSISTANT_PREFERRED_AI_ASSISTANT_TYPE];
const SettingsContextProvider = ({
  children
}) => {
  const value = useSettings({
    settingsKeys: SETTING_KEYS
  });
  return /*#__PURE__*/_react.default.createElement(SettingsContext.Provider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 10
    }
  }, children);
};
exports.SettingsContextProvider = SettingsContextProvider;
function combineErrors(errors) {
  const message = errors.map(err => err.message || String(err)).join('; ');
  return new Error(message);
}
function getSettingsFields({
  settingsKeys,
  uiSettings
}) {
  if (!uiSettings) {
    return {};
  }
  const uiSettingsDefinition = uiSettings.getAll();
  const normalizedSettings = (0, _managementSettingsUtilities.normalizeSettings)(uiSettingsDefinition);
  return settingsKeys.reduce((acc, key) => {
    const setting = normalizedSettings[key];
    if (setting) {
      const field = (0, _managementSettingsFieldDefinition.getFieldDefinition)({
        id: key,
        setting,
        params: {
          isCustom: uiSettings.isCustom(key),
          isOverridden: uiSettings.isOverridden(key)
        }
      });
      acc[key] = field;
    }
    return acc;
  }, {});
}
const useSettings = ({
  settingsKeys
}) => {
  var _fieldsQuery$data2;
  const {
    services: {
      settings,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const [unsavedChanges, setUnsavedChanges] = _react.default.useState({});

  // Custom validation errors from external validators
  const [customValidationErrors, setCustomValidationErrors] = _react.default.useState([]);
  const queryClient = (0, _reactQuery.useQueryClient)();
  const fieldsQuery = (0, _reactQuery.useQuery)({
    queryKey: ['settingsFields', settingsKeys],
    queryFn: async () => {
      return getSettingsFields({
        settingsKeys,
        uiSettings: settings === null || settings === void 0 ? void 0 : settings.client
      });
    },
    refetchOnWindowFocus: true
  });
  const saveSingleSettingMutation = (0, _reactQuery.useMutation)({
    mutationFn: async ({
      id,
      change
    }) => {
      await settings.client.set(id, change);
      queryClient.invalidateQueries({
        queryKey: ['settingsFields', settingsKeys]
      });
    }
  });
  const saveAllMutation = (0, _reactQuery.useMutation)({
    mutationFn: async () => {
      if (settings && !(0, _lodash.isEmpty)(unsavedChanges)) {
        // Validate fields before saving
        if (customValidationErrors.length > 0) {
          // Throw error to prevent save
          throw new Error(customValidationErrors.map(error => error.message).join('\n'));
        }
        const updateErrors = [];
        const subscription = settings.client.getUpdateErrors$().subscribe(error => {
          updateErrors.push(error);
        });
        try {
          var _fieldsQuery$data;
          const fieldsMap = (_fieldsQuery$data = fieldsQuery.data) !== null && _fieldsQuery$data !== void 0 ? _fieldsQuery$data : {};
          const requiresReload = Object.keys(unsavedChanges).some(key => {
            var _fieldsMap$key;
            return ((_fieldsMap$key = fieldsMap[key]) === null || _fieldsMap$key === void 0 ? void 0 : _fieldsMap$key.requiresPageReload) === true;
          });
          await Promise.all(Object.entries(unsavedChanges).map(([key, value]) => {
            return settings.client.set(key, value.unsavedValue);
          }));
          queryClient.invalidateQueries({
            queryKey: ['settingsFields', settingsKeys]
          });
          cleanUnsavedChanges();
          if (updateErrors.length > 0) {
            throw combineErrors(updateErrors);
          }
          return requiresReload;
        } finally {
          if (subscription) {
            subscription.unsubscribe();
          }
        }
      }
      return false;
    },
    onSuccess() {
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.gen_ai_settings.save.success', {
          defaultMessage: 'Settings saved'
        })
      });
    },
    onError(error) {
      var _error$message;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.gen_ai_settings.save.error', {
          defaultMessage: 'Failed to save settings'
        }),
        text: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : _i18n.i18n.translate('xpack.gen_ai_settings.save.error.text', {
          defaultMessage: 'Unknown error'
        })
      });
    }
  });
  const handleFieldChange = (id, change) => {
    if (!change) {
      const {
        [id]: unsavedChange,
        ...rest
      } = unsavedChanges;
      setUnsavedChanges(rest);
      return;
    }
    setUnsavedChanges(changes => ({
      ...changes,
      [id]: change
    }));
  };
  function cleanUnsavedChanges() {
    setUnsavedChanges({});
  }
  const setValidationErrors = _react.default.useCallback(errors => {
    if (typeof errors === 'function') {
      setCustomValidationErrors(current => errors(current));
    } else {
      setCustomValidationErrors(errors);
    }
  }, []);
  return {
    fields: (_fieldsQuery$data2 = fieldsQuery.data) !== null && _fieldsQuery$data2 !== void 0 ? _fieldsQuery$data2 : {},
    unsavedChanges,
    handleFieldChange,
    saveAll: saveAllMutation.mutateAsync,
    isSaving: saveAllMutation.isLoading || saveSingleSettingMutation.isLoading,
    cleanUnsavedChanges,
    saveSingleSetting: saveSingleSettingMutation.mutateAsync,
    setValidationErrors
  };
};
/**
 * Field-specific hook for settings context with automatic validation error management
 * @param fieldNames - Array of field names this hook instance is responsible for
 * @param validationFn - Optional validation function that will be called automatically when dependencies change
 * @param validationDeps - Dependencies for the validation function
 * @returns Settings context with field-scoped validation error management
 */
const useFieldSettingsContext = (fieldNames, validationFn, validationDeps) => {
  const context = useSettingsContext();

  // Validate that we have field names
  if (!fieldNames || fieldNames.length === 0) {
    throw new Error('useFieldSettingsContext requires at least one field name');
  }

  // Memoize field names to ensure stable reference
  const fieldNamesString = JSON.stringify(fieldNames);
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const stableFieldNames = _react.default.useMemo(() => fieldNames, [fieldNamesString]);

  // Track last validation errors to prevent unnecessary updates
  const lastValidationErrorsRef = _react.default.useRef([]);

  // Create a field-scoped setValidationErrors function with deduplication
  const setValidationErrors = _react.default.useCallback(errors => {
    // Validate that all errors belong to the allowed fields
    const invalidErrors = errors.filter(error => error.field && !stableFieldNames.includes(error.field));
    if (invalidErrors.length > 0) {
      const invalidFields = invalidErrors.map(e => e.field).join(', ');
      throw new Error(`Validation errors contain fields not managed by this hook instance. ` + `Invalid fields: ${invalidFields}. Allowed fields: ${stableFieldNames.join(', ')}`);
    }

    // Check if errors have actually changed to prevent unnecessary updates
    const errorsChanged = errors.length !== lastValidationErrorsRef.current.length || errors.some((error, index) => {
      var _lastValidationErrors, _lastValidationErrors2;
      return error.message !== ((_lastValidationErrors = lastValidationErrorsRef.current[index]) === null || _lastValidationErrors === void 0 ? void 0 : _lastValidationErrors.message) || error.field !== ((_lastValidationErrors2 = lastValidationErrorsRef.current[index]) === null || _lastValidationErrors2 === void 0 ? void 0 : _lastValidationErrors2.field);
    });
    if (errorsChanged) {
      lastValidationErrorsRef.current = errors;

      // Set the validation errors using the original context method
      context.setValidationErrors(currentErrors => {
        // Remove any existing errors for our fields
        const otherErrors = currentErrors.filter(error => !error.field || !stableFieldNames.includes(error.field));
        // Add the new errors for our fields
        return [...otherErrors, ...errors];
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [context.setValidationErrors, stableFieldNames]);

  // Auto-run validation function when dependencies change
  _react.default.useEffect(() => {
    if (validationFn && validationDeps) {
      const errors = validationFn(...validationDeps);
      setValidationErrors(errors);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  validationDeps ? [...validationDeps, setValidationErrors, validationFn] : [setValidationErrors, validationFn]);

  // Automatically clear errors for our fields when the hook unmounts
  _react.default.useEffect(() => {
    return () => {
      context.setValidationErrors(currentErrors => currentErrors.filter(error => !error.field || !stableFieldNames.includes(error.field)));
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [context.setValidationErrors, stableFieldNames]);

  // Return the context with our field-scoped validation function
  return {
    ...context,
    setValidationErrors
  };
};
exports.useFieldSettingsContext = useFieldSettingsContext;