"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FILES_METADATA_BY_ACTION_ID = exports.AGENT_ACTIONS_RESULTS_FIXTURES = exports.AGENT_ACTIONS_FIXTURES = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_ACTIONS_FIXTURES = exports.AGENT_ACTIONS_FIXTURES = [{
  _source: {
    action_id: 'current-in-progress-action',
    '@timestamp': (0, _moment.default)().subtract('5', 'minute').toISOString(),
    expiration: (0, _moment.default)().add(1, 'day').toISOString()
  }
}, {
  _source: {
    action_id: 'current-complete-action',
    '@timestamp': (0, _moment.default)().subtract('5', 'minute').toISOString(),
    expiration: (0, _moment.default)().add(1, 'day').toISOString()
  }
}, {
  _source: {
    action_id: 'expired-incomplete-action',
    '@timestamp': (0, _moment.default)().subtract(6, 'hour').toISOString(),
    expiration: (0, _moment.default)().subtract(3, 'hour').toISOString()
  }
}, {
  _source: {
    action_id: 'expired-complete-action',
    '@timestamp': (0, _moment.default)().subtract(6, 'hour').toISOString(),
    expiration: (0, _moment.default)().subtract(3, 'hour').toISOString()
  }
}, {
  _source: {
    action_id: 'current-error-action',
    '@timestamp': (0, _moment.default)().subtract('5', 'minute').toISOString(),
    expiration: (0, _moment.default)().add(1, 'day').toISOString()
  }
}, {
  _source: {
    action_id: 'expired-error-action',
    '@timestamp': (0, _moment.default)().subtract(6, 'hour').toISOString(),
    expiration: (0, _moment.default)().subtract(3, 'hour').toISOString()
  }
}, {
  _source: {
    action_id: 'current-deleted-action',
    '@timestamp': (0, _moment.default)().subtract('5', 'minute').toISOString(),
    expiration: (0, _moment.default)().add(1, 'day').toISOString()
  }
}, {
  _source: {
    action_id: 'expired-deleted-action',
    '@timestamp': (0, _moment.default)().subtract(6, 'hour').toISOString(),
    expiration: (0, _moment.default)().subtract(3, 'hour').toISOString()
  }
}, {
  _source: {
    action_id: 'old-incomplete-action',
    '@timestamp': (0, _moment.default)().subtract(90, 'day').toISOString(),
    expiration: (0, _moment.default)().subtract(89, 'day').toISOString()
  }
}, {
  _source: {
    action_id: 'old-complete-action',
    '@timestamp': (0, _moment.default)().subtract(90, 'day').toISOString(),
    expiration: (0, _moment.default)().subtract(89, 'day').toISOString()
  }
}];
const AGENT_ACTIONS_RESULTS_FIXTURES = exports.AGENT_ACTIONS_RESULTS_FIXTURES = [{
  _source: {
    action_id: 'current-in-progress-action'
  }
}, {
  _source: {
    action_id: 'current-complete-action',
    data: {
      upload_id: 'current-complete-file'
    }
  }
}, {
  _source: {
    action_id: 'expired-incomplete-action'
  }
}, {
  _source: {
    action_id: 'expired-complete-action',
    data: {
      upload_id: 'expired-complete-file'
    }
  }
}, {
  _source: {
    action_id: 'current-error-action',
    error: 'some diagnostics err'
  }
}, {
  _source: {
    action_id: 'expired-error-action',
    error: 'some diagnostics err'
  }
}, {
  _source: {
    action_id: 'current-deleted-action',
    data: {
      upload_id: 'current-deleted-file'
    }
  }
}, {
  _source: {
    action_id: 'expired-deleted-action',
    data: {
      upload_id: 'expired-deleted-file'
    }
  }
}, {
  _source: {
    action_id: 'old-incomplete-action'
  }
}, {
  _source: {
    action_id: 'old-complete-action',
    data: {
      upload_id: 'old-complete-file'
    }
  }
}];
const FILES_METADATA_BY_ACTION_ID = exports.FILES_METADATA_BY_ACTION_ID = {
  'current-complete-action': {
    _id: 'current-complete-file',
    _source: {
      file: {
        name: 'current-complete-file.zip',
        Status: 'READY'
      }
    }
  },
  'expired-complete-action': {
    _id: 'expired-complete-file',
    _source: {
      file: {
        name: 'expired-complete-file.zip',
        Status: 'READY'
      }
    }
  },
  'current-deleted-action': {
    _id: 'current-complete-file',
    _source: {
      file: {
        name: 'current-complete-file.zip',
        Status: 'DELETED'
      }
    }
  },
  'expired-deleted-action': {
    _id: 'expired-complete-file',
    _source: {
      file: {
        name: 'expired-complete-file.zip',
        Status: 'DELETED'
      }
    }
  },
  'old-complete-action': {
    _id: 'old-complete-file',
    _source: {
      file: {
        name: 'old-complete-file.zip',
        Status: 'READY'
      }
    }
  }
};