"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceSettingsContextProvider = void 0;
exports.useSpaceSettingsContext = useSpaceSettingsContext;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../services");
var _use_authz = require("./use_authz");
var _use_request = require("./use_request");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/hooks/use_space_settings_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const spaceSettingsContext = /*#__PURE__*/(0, _react.createContext)({
  allowedNamespacePrefixes: [],
  defaultNamespace: 'default'
});
const SpaceSettingsContextProvider = ({
  enabled = true,
  children
}) => {
  var _ExperimentalFeatures, _ExperimentalFeatures2;
  const useSpaceAwareness = (_ExperimentalFeatures = (_ExperimentalFeatures2 = _services.ExperimentalFeaturesService.get()) === null || _ExperimentalFeatures2 === void 0 ? void 0 : _ExperimentalFeatures2.useSpaceAwareness) !== null && _ExperimentalFeatures !== void 0 ? _ExperimentalFeatures : false;
  const authz = (0, _use_authz.useAuthz)();
  const isAllowed = authz.fleet.allAgentPolicies || authz.fleet.allSettings || authz.integrations.writeIntegrationPolicies;
  const spaceSettingsReq = (0, _use_request.useGetSpaceSettings)({
    enabled: useSpaceAwareness && enabled && isAllowed
  });
  const settings = _react.default.useMemo(() => {
    var _spaceSettingsReq$dat, _spaceSettingsReq$dat2, _spaceSettingsReq$dat3, _spaceSettingsReq$dat4, _spaceSettingsReq$dat5;
    return {
      isInitialLoading: spaceSettingsReq.isInitialLoading,
      allowedNamespacePrefixes: (_spaceSettingsReq$dat = (_spaceSettingsReq$dat2 = spaceSettingsReq.data) === null || _spaceSettingsReq$dat2 === void 0 ? void 0 : _spaceSettingsReq$dat2.item.allowed_namespace_prefixes) !== null && _spaceSettingsReq$dat !== void 0 ? _spaceSettingsReq$dat : [],
      defaultNamespace: (_spaceSettingsReq$dat3 = (_spaceSettingsReq$dat4 = spaceSettingsReq.data) === null || _spaceSettingsReq$dat4 === void 0 ? void 0 : (_spaceSettingsReq$dat5 = _spaceSettingsReq$dat4.item.allowed_namespace_prefixes) === null || _spaceSettingsReq$dat5 === void 0 ? void 0 : _spaceSettingsReq$dat5[0]) !== null && _spaceSettingsReq$dat3 !== void 0 ? _spaceSettingsReq$dat3 : 'default'
    };
  }, [spaceSettingsReq.isInitialLoading, spaceSettingsReq.data]);
  return /*#__PURE__*/_react.default.createElement(spaceSettingsContext.Provider, {
    value: settings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 10
    }
  }, children);
};
exports.SpaceSettingsContextProvider = SpaceSettingsContextProvider;
function useSpaceSettingsContext() {
  return (0, _react.useContext)(spaceSettingsContext);
}