"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendDeleteFleetProxy = sendDeleteFleetProxy;
exports.sendPostFleetProxy = sendPostFleetProxy;
exports.sendPutFleetProxy = sendPutFleetProxy;
exports.useGetFleetProxies = useGetFleetProxies;
var _services = require("../../../common/services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetFleetProxies() {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.fleetProxiesRoutesService.getListPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendDeleteFleetProxy(proxyId) {
  return (0, _use_request.sendRequest)({
    method: 'delete',
    path: _services.fleetProxiesRoutesService.getDeletePath(proxyId),
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendPostFleetProxy(body) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.fleetProxiesRoutesService.getCreatePath(),
    body,
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendPutFleetProxy(proxyId, body) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.fleetProxiesRoutesService.getUpdatePath(proxyId),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}