"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePermissionCheckQuery = exports.usePermissionCheck = exports.sendGetPermissionsCheck = exports.sendGenerateServiceToken = void 0;
var _reactQuery = require("@kbn/react-query");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendGetPermissionsCheck = fleetServerSetup => {
  return (0, _use_request.sendRequest)({
    path: _services.appRoutesService.getCheckPermissionsPath(),
    method: 'get',
    query: {
      fleetServerSetup
    },
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetPermissionsCheck = sendGetPermissionsCheck;
const sendGenerateServiceToken = remote => {
  return (0, _use_request.sendRequest)({
    path: _services.appRoutesService.getRegenerateServiceTokenPath(),
    method: 'post',
    query: {
      remote
    },
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGenerateServiceToken = sendGenerateServiceToken;
const usePermissionCheckQuery = () => {
  return (0, _reactQuery.useQuery)(['permissionsCheck'], () => (0, _use_request.sendRequestForRq)({
    path: _services.appRoutesService.getCheckPermissionsPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  }));
};
exports.usePermissionCheckQuery = usePermissionCheckQuery;
const usePermissionCheck = () => {
  return (0, _use_request.useRequest)({
    path: _services.appRoutesService.getCheckPermissionsPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.usePermissionCheck = usePermissionCheck;