"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultipleAgentPoliciesSummaryLine = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../hooks");
var _manage_agent_policies_modal = require("./manage_agent_policies_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/multiple_agent_policy_summary_line.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MIN_WIDTH = {
  minWidth: 0
};
const NO_WRAP_WHITE_SPACE = {
  whiteSpace: 'nowrap'
};
const MultipleAgentPoliciesSummaryLine = exports.MultipleAgentPoliciesSummaryLine = /*#__PURE__*/(0, _react.memo)(({
  policies,
  direction = 'row',
  packagePolicyId,
  onAgentPoliciesChange
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const [policiesModalEnabled, setPoliciesModalEnabled] = (0, _react.useState)(false);
  const authz = (0, _hooks.useAuthz)();
  const canManageAgentPolicies = authz.integrations.writeIntegrationPolicies && authz.fleet.allAgentPolicies;

  // as default, show only the first policy
  const policy = policies[0];
  const {
    name,
    id,
    is_managed: isManaged,
    revision
  } = policy;
  const listItems = (0, _react.useMemo)(() => {
    return policies.map(p => {
      return {
        'data-test-subj': `policy-${p.id}`,
        label: p.name || p.id,
        href: getHref('policy_details', {
          policyId: p.id
        }),
        iconType: 'dot',
        extraAction: {
          color: 'text',
          iconType: p.is_managed ? 'lock' : '',
          alwaysShow: !!p.is_managed,
          iconSize: 's',
          'aria-label': 'Hosted agent policy'
        },
        showToolTip: !!p.is_managed,
        toolTipText: _i18n.i18n.translate('xpack.fleet.agentPolicySummaryLine.hostedPolicyTooltip', {
          defaultMessage: 'This policy is managed outside of Fleet. Most actions related to this policy are unavailable.'
        })
      };
    });
  }, [getHref, policies]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: direction,
    gutterSize: direction === 'column' ? 'none' : 's',
    alignItems: "baseline",
    style: MIN_WIDTH,
    responsive: false,
    justifyContent: 'flexStart',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: MIN_WIDTH,
    gutterSize: "s",
    alignItems: "baseline",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: `eui-textTruncate`,
    href: getHref('policy_details', {
      policyId: id
    }),
    title: name || id,
    "data-test-subj": "agentPolicyNameLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 19
    }
  }, name || id)), isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: "Hosted agent policy",
    content: _i18n.i18n.translate('xpack.fleet.agentPolicySummaryLine.hostedPolicyTooltip', {
      defaultMessage: 'This policy is managed outside of Fleet. Most actions related to this policy are unavailable.'
    }),
    type: "lock",
    size: "m",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 21
    }
  })), revision && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    style: NO_WRAP_WHITE_SPACE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicySummaryLine.revisionNumber",
    defaultMessage: "rev. {revNumber}",
    values: {
      revNumber: revision
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 23
    }
  }))), policies.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "agentPoliciesNumberBadge",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    onClickAriaLabel: "Open agent policies popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 21
    }
  }, "+", policies.length - 1), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "agentPoliciesPopover",
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('xpack.fleet.agentPolicySummaryLine.popover.title', {
    defaultMessage: 'This integration is shared by'
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '280px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: listItems,
    color: "primary",
    size: "s",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fullWidth: true,
    size: "s",
    "data-test-subj": "agentPoliciesPopoverButton",
    onClick: () => setPoliciesModalEnabled(true),
    isDisabled: !canManageAgentPolicies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 25
    }
  }, _i18n.i18n.translate('xpack.fleet.agentPolicySummaryLine.popover.button', {
    defaultMessage: 'Manage agent policies'
  })))))))))), policiesModalEnabled && /*#__PURE__*/_react.default.createElement(_manage_agent_policies_modal.ManageAgentPoliciesModal, {
    onClose: () => setPoliciesModalEnabled(false),
    onAgentPoliciesChange: onAgentPoliciesChange,
    selectedAgentPolicies: policies,
    packagePolicyId: packagePolicyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }));
});