"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instructions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _agent_requirements_page = require("../../applications/fleet/sections/agents/agent_requirements_page");
var _constants = require("../../constants");
var _ = require("..");
var _advanced_tab = require("../../applications/fleet/components/fleet_server_instructions/advanced_tab");
var _steps = require("./steps");
var _default_missing_requirements = require("./default_missing_requirements");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Instructions = props => {
  var _fleetStatus$missingR;
  const {
    isFleetServerPolicySelected,
    fleetServerHost,
    isLoadingAgentPolicies,
    selectionType,
    setSelectionType,
    mode,
    setMode,
    isIntegrationFlow
  } = props;
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const {
    isFleetServerStandalone
  } = (0, _hooks.useFleetServerStandalone)();
  const {
    isLoading: isLoadingEnrollmentSettings,
    data: enrollmentSettings
  } = (0, _hooks.useGetEnrollmentSettings)();
  const hasNoFleetServerHost = fleetStatus.isReady && !fleetServerHost;
  const showAgentEnrollment = isFleetServerPolicySelected || isFleetServerStandalone || fleetStatus.isReady && (enrollmentSettings === null || enrollmentSettings === void 0 ? void 0 : enrollmentSettings.fleet_server.has_active) && fleetServerHost;
  const showFleetServerEnrollment = !isFleetServerStandalone && !isFleetServerPolicySelected && (!(enrollmentSettings !== null && enrollmentSettings !== void 0 && enrollmentSettings.fleet_server.has_active) || ((_fleetStatus$missingR = fleetStatus.missingRequirements) !== null && _fleetStatus$missingR !== void 0 ? _fleetStatus$missingR : []).some(r => r === _constants.FLEET_SERVER_PACKAGE));
  (0, _react.useEffect)(() => {
    var _props$cloudSecurityI, _props$cloudSecurityI2, _props$cloudSecurityI3;
    // If we detect a CloudFormation integration, we want to hide the selection type
    if ((_props$cloudSecurityI = props.cloudSecurityIntegration) !== null && _props$cloudSecurityI !== void 0 && _props$cloudSecurityI.isAzureArmTemplate || (_props$cloudSecurityI2 = props.cloudSecurityIntegration) !== null && _props$cloudSecurityI2 !== void 0 && _props$cloudSecurityI2.isCloudFormation || (_props$cloudSecurityI3 = props.cloudSecurityIntegration) !== null && _props$cloudSecurityI3 !== void 0 && _props$cloudSecurityI3.cloudShellUrl) {
      setSelectionType(undefined);
    } else if (!isIntegrationFlow && showAgentEnrollment) {
      setSelectionType('radio');
    } else {
      setSelectionType('tabs');
    }
  }, [isIntegrationFlow, showAgentEnrollment, setSelectionType, props.cloudSecurityIntegration]);
  if (isLoadingEnrollmentSettings || isLoadingAgentPolicies) return /*#__PURE__*/_react.default.createElement(_.Loading, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 69
    }
  });
  if (hasNoFleetServerHost) {
    return null;
  }
  if (mode === 'managed') {
    if (showFleetServerEnrollment) {
      return /*#__PURE__*/_react.default.createElement(_agent_requirements_page.FleetServerRequirementPage, {
        showStandaloneTab: () => setMode('standalone'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 14
        }
      });
    } else if (showAgentEnrollment) {
      var _props$cloudSecurityI4, _props$selectedPolicy;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectionType === 'tabs' && !((_props$cloudSecurityI4 = props.cloudSecurityIntegration) !== null && _props$cloudSecurityI4 !== void 0 && _props$cloudSecurityI4.cloudShellUrl) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentEnrollment.managedDescription",
        defaultMessage: "Enroll an Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 15
        }
      })), isFleetServerPolicySelected ? /*#__PURE__*/_react.default.createElement(_advanced_tab.AdvancedTab, {
        selectedPolicyId: (_props$selectedPolicy = props.selectedPolicy) === null || _props$selectedPolicy === void 0 ? void 0 : _props$selectedPolicy.id,
        onClose: () => undefined,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_steps.ManagedSteps, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 13
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_default_missing_requirements.DefaultMissingRequirements, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(StandaloneInstructions, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 12
      }
    }));
  }
};
exports.Instructions = Instructions;
const StandaloneInstructions = props => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.standaloneDescription",
    defaultMessage: "Run an Elastic Agent standalone to configure and update the agent manually on the host where the agent is installed.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_steps.StandaloneSteps, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  })));
};