"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteOutput = useDeleteOutput;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _agent_and_policies_count = require("../services/agent_and_policies_count");
var _use_confirm_modal = require("./use_confirm_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/hooks/use_delete_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteOutput.confirmModalTitle",
  defaultMessage: "Delete and deploy changes?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 3
  }
});
const ConfirmDescription = ({
  output,
  agentCount,
  agentPolicyCount
}) => agentCount !== undefined && agentPolicyCount !== undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteOutput.confirmModalText",
  defaultMessage: "This action will delete {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",
  values: {
    outputName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 21
      }
    }, output.name),
    agents: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteOutput.agentsCount",
      defaultMessage: "{agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    })),
    policies: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteOutput.agentPolicyCount",
      defaultMessage: "{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",
      values: {
        agentPolicyCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 5
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteOutput.confirmModalTextWithCount",
  defaultMessage: "This action will delete {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",
  values: {
    outputName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 21
      }
    }, output.name)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 5
  }
});
function useDeleteOutput(onSuccess) {
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const deleteOutput = (0, _react.useCallback)(async output => {
    try {
      const {
        agentCount,
        agentPolicyCount
      } = await (0, _agent_and_policies_count.getAgentAndPolicyCountForOutput)(output).catch(() => ({
        // Fail gracefully if count are not available
        agentCount: undefined,
        agentPolicyCount: undefined
      }));
      const isConfirmed = await confirm(/*#__PURE__*/_react.default.createElement(ConfirmTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(ConfirmDescription, {
        output: output,
        agentCount: agentCount,
        agentPolicyCount: agentPolicyCount,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 11
        }
      }), {
        buttonColor: 'danger',
        confirmButtonText: _i18n.i18n.translate('xpack.fleet.settings.deleteOutputs.confirmButtonLabel', {
          defaultMessage: 'Delete and deploy'
        })
      });
      if (!isConfirmed) {
        return;
      }
      const res = await (0, _hooks.sendDeleteOutput)(output.id);
      if (res.error) {
        throw res.error;
      }
      onSuccess();
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.deleteOutputs.errorToastTitle', {
          defaultMessage: 'Error deleting output'
        })
      });
    }
  }, [confirm, notifications.toasts, onSuccess]);
  return {
    deleteOutput
  };
}