"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _layouts = require("../../../layouts");
var _components2 = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/details_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyDetailsPage = () => {
  var _agentPolicyRequest$d;
  const {
    params: {
      policyId,
      tabId = ''
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    urlParams
  } = (0, _hooks.useUrlParams)();
  const {
    showAgentless
  } = (0, _hooks.useAgentlessResources)();
  const agentPolicyRequest = (0, _hooks.useGetOneAgentPolicy)(policyId);
  // If the agent policy is agentless, hide it by default unless showAgentless toggle is enabled
  const agentPolicy = (_agentPolicyRequest$d = agentPolicyRequest.data) !== null && _agentPolicyRequest$d !== void 0 && _agentPolicyRequest$d.item && (!agentPolicyRequest.data.item.supports_agentless || showAgentless) ? agentPolicyRequest.data.item : null;
  const {
    isLoading,
    error,
    sendRequest: refreshAgentPolicy
  } = agentPolicyRequest;
  const openEnrollmentFlyoutOpenByDefault = urlParams.openEnrollmentFlyout === 'true';
  const openAddAgentHelpPopoverOpenByDefault = urlParams.showAddAgentHelp === 'true';
  const [redirectToAgentPolicyList] = (0, _react.useState)(false);
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(openEnrollmentFlyoutOpenByDefault);
  const [isAddAgentHelpPopoverOpen, setIsAddAgentHelpPopoverOpen] = (0, _react.useState)(openAddAgentHelpPopoverOpenByDefault);
  const {
    application: {
      navigateToApp
    }
  } = (0, _hooks.useStartServices)();
  const routeState = (0, _hooks.useIntraAppState)();
  const {
    isReady: isFleetReady
  } = (0, _hooks.useFleetStatus)();
  const onCancelEnrollment = (0, _react.useMemo)(() => {
    if (routeState && routeState.onDoneNavigateTo && isFleetReady) {
      const [appId, options] = routeState.onDoneNavigateTo;
      return () => navigateToApp(appId, options);
    }
    return undefined;
  }, [isFleetReady, navigateToApp, routeState]);
  const addAgent = (0, _react.useCallback)(() => {
    setIsAddAgentHelpPopoverOpen(false);
    setIsEnrollmentFlyoutOpen(true);
  }, []);
  const headerTabs = (0, _react.useMemo)(() => {
    return [{
      id: 'integrations',
      name: _i18n.i18n.translate('xpack.fleet.policyDetails.subTabs.packagePoliciesTabText', {
        defaultMessage: 'Integrations'
      }),
      href: getHref('policy_details', {
        policyId,
        tabId: 'integrations'
      }),
      isSelected: tabId === '' || tabId === 'integrations'
    }, {
      id: 'settings',
      name: _i18n.i18n.translate('xpack.fleet.policyDetails.subTabs.settingsTabText', {
        defaultMessage: 'Settings'
      }),
      'data-test-subj': 'agentPolicySettingsTab',
      href: getHref('policy_details', {
        policyId,
        tabId: 'settings'
      }),
      isSelected: tabId === 'settings'
    }];
  }, [getHref, policyId, tabId]);
  const content = (0, _react.useMemo)(() => {
    if (redirectToAgentPolicyList) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: "/",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 14
        }
      });
    }
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_components.Loading, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 14
        }
      });
    }
    if (error) {
      return /*#__PURE__*/_react.default.createElement(_components.Error, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.policyDetails.unexceptedErrorTitle",
          defaultMessage: "An error happened while loading the agent policy",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 13
          }
        }),
        error: error,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 9
        }
      });
    }
    if (!agentPolicy) {
      return /*#__PURE__*/_react.default.createElement(_components.Error, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.policyDetails.unexceptedErrorTitle",
          defaultMessage: "An error happened while loading the agent policy",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 13
          }
        }),
        error: _i18n.i18n.translate('xpack.fleet.policyDetails.policyNotFoundErrorTitle', {
          defaultMessage: "Policy ''{id}'' not found",
          values: {
            id: policyId
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
      agentPolicy: agentPolicy,
      onClose: onCancelEnrollment || (() => setIsEnrollmentFlyoutOpen(false)),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(AgentPolicyDetailsContent, {
      agentPolicy: agentPolicy,
      refreshAgentPolicy: refreshAgentPolicy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }));
  }, [redirectToAgentPolicyList, isLoading, error, agentPolicy, isEnrollmentFlyoutOpen, onCancelEnrollment, policyId, refreshAgentPolicy]);
  const headerLeftContent = /*#__PURE__*/_react.default.createElement(_components2.HeaderLeftContent, {
    agentPolicy: agentPolicy,
    policyId: policyId,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  });
  const headerRightContent = /*#__PURE__*/_react.default.createElement(_components2.HeaderRightContent, {
    agentPolicy: agentPolicy,
    onCancelEnrollment: onCancelEnrollment,
    isLoading: isLoading,
    isAddAgentHelpPopoverOpen: isAddAgentHelpPopoverOpen,
    setIsAddAgentHelpPopoverOpen: setIsAddAgentHelpPopoverOpen,
    addAgent: addAgent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_hooks.AgentPolicyRefreshContext.Provider, {
    value: {
      refresh: refreshAgentPolicy
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: headerLeftContent,
    rightColumn: headerRightContent,
    tabs: headerTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, content));
};
exports.AgentPolicyDetailsPage = AgentPolicyDetailsPage;
const AgentPolicyDetailsContent = ({
  agentPolicy,
  refreshAgentPolicy
}) => {
  (0, _hooks.useBreadcrumbs)('policy_details', {
    policyName: agentPolicy.name
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policy_details_settings,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components2.SettingsView, {
        agentPolicy: agentPolicy,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 18
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.policy_details,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components2.PackagePoliciesView, {
        agentPolicy: agentPolicy,
        refreshAgentPolicy: refreshAgentPolicy,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 13
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }));
};