"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorFormat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _server = _interopRequireDefault(require("react-dom/server"));
var _lodash = require("lodash");
var _fieldTypes = require("@kbn/field-types");
var _field_format = require("../field_format");
var _types = require("../types");
var _utils = require("../utils");
var _color_default = require("../constants/color_default");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/field_formats/common/converters/color.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @public */
class ColorFormat extends _field_format.FieldFormat {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "htmlConvert", (val, options) => {
      const color = this.findColorRuleForVal(val);
      const displayVal = (0, _lodash.escape)((0, _utils.asPrettyString)(val, options));
      if (!color) return displayVal;
      return _server.default.renderToStaticMarkup(/*#__PURE__*/_react.default.createElement("span", {
        // using `style` so we can test with jest and emotion does not work for these formatter utils
        // EuiBadge is not multiline, so we define custom styles here instead of using it.
        style: {
          color: color.text,
          backgroundColor: color.background,
          display: 'inline-block',
          padding: '0 8px',
          borderRadius: '3px'
        },
        dangerouslySetInnerHTML: {
          __html: displayVal
        } // eslint-disable-line react/no-danger
        ,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 7
        }
      }));
    });
  }
  getParamDefaults() {
    return {
      fieldType: null,
      // populated by editor, see controller below
      colors: [(0, _lodash.cloneDeep)(_color_default.DEFAULT_CONVERTER_COLOR)]
    };
  }
  findColorRuleForVal(val) {
    switch (this.param('fieldType')) {
      case 'string':
        return (0, _lodash.findLast)(this.param('colors'), colorParam => {
          try {
            return new RegExp(colorParam.regex).test(val);
          } catch (e) {
            return false;
          }
        });
      case 'number':
        return (0, _lodash.findLast)(this.param('colors'), ({
          range
        }) => {
          if (!range) return;
          const [start, end] = range.split(':');
          // @ts-expect-error upgrade typescript v5.1.6
          return val >= Number(start) && val <= Number(end);
        });
      case 'boolean':
        return (0, _lodash.findLast)(this.param('colors'), ({
          boolean
        }) => {
          return boolean === val.toString();
        });
      default:
        return null;
    }
  }
}
exports.ColorFormat = ColorFormat;
(0, _defineProperty2.default)(ColorFormat, "id", _types.FIELD_FORMAT_IDS.COLOR);
(0, _defineProperty2.default)(ColorFormat, "title", _i18n.i18n.translate('fieldFormats.color.colorOrBadgeTitle', {
  defaultMessage: 'Color / Badge'
}));
(0, _defineProperty2.default)(ColorFormat, "fieldType", [_fieldTypes.KBN_FIELD_TYPES.NUMBER, _fieldTypes.KBN_FIELD_TYPES.STRING, _fieldTypes.KBN_FIELD_TYPES.BOOLEAN]);