"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectableUrlList = SelectableUrlList;
exports.formatOptions = exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useEvent = _interopRequireDefault(require("react-use/lib/useEvent"));
var _classnames = _interopRequireDefault(require("classnames"));
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/components/url_search/selectable_url_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formatOptions = options => {
  return options.map(item => ({
    title: item.label,
    ...item,
    className: (0, _classnames.default)('euiSelectableTemplateSitewide__listItem', item.className)
  }));
};
exports.formatOptions = formatOptions;
function SelectableUrlList({
  data,
  loading,
  onInputChange,
  onSelectionChange,
  onSelectionApply,
  searchValue,
  popoverIsOpen,
  setPopoverIsOpen,
  initialValue,
  renderOption,
  rowHeight,
  hasChanged
}) {
  var _data$items, _data$total;
  const [searchRef, setSearchRef] = (0, _react.useState)(null);
  const titleRef = (0, _react.useRef)(null);
  const formattedOptions = formatOptions((_data$items = data.items) !== null && _data$items !== void 0 ? _data$items : []);
  const onEnterKey = evt => {
    if (evt.key.toLowerCase() === 'enter') {
      onSelectionApply();
      setPopoverIsOpen(false);
    }
  };
  const onInputClick = e => {
    setPopoverIsOpen(true);
    if (searchRef) {
      searchRef.focus();
    }
  };
  const onSearchInput = e => {
    onInputChange(e.target.value);
    setPopoverIsOpen(true);
  };
  const closePopover = () => {
    setPopoverIsOpen(false);
  };

  // @ts-ignore - not sure, why it's not working
  (0, _useEvent.default)('keydown', onEnterKey, searchRef);
  (0, _useEvent.default)('escape', () => setPopoverIsOpen(false), searchRef);
  const loadingMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
    style: {
      minHeight: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, _translations.I18LABELS.loadingResults));
  const emptyMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
    style: {
      minHeight: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, _translations.I18LABELS.noResults));
  const titleText = searchValue ? _translations.I18LABELS.getSearchResultsLabel((_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0) : _translations.I18LABELS.topPages;
  function PopOverTitle() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      ref: titleRef,
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        justifyContent: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 24
      }
    }) : titleText), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "exploratoryViewPopOverTitleButton",
      color: "text",
      onClick: () => closePopover(),
      "aria-label": _i18n.i18n.translate('xpack.exploratoryView.search.url.close', {
        defaultMessage: 'Close'
      }),
      iconType: 'cross',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    onChange: onSelectionChange,
    options: searchValue !== (searchRef === null || searchRef === void 0 ? void 0 : searchRef.value) ? [] : formattedOptions,
    renderOption: renderOption,
    singleSelection: false,
    searchProps: {
      value: searchValue,
      isClearable: true,
      onClick: onInputClick,
      onInput: onSearchInput,
      inputRef: setSearchRef,
      placeholder: _translations.I18LABELS.filterByUrl,
      'aria-label': _translations.I18LABELS.filterByUrl
    },
    listProps: {
      rowHeight,
      showIcons: true,
      onFocusBadge: false
    },
    loadingMessage: loadingMessage,
    emptyMessage: emptyMessage,
    noMatchesMessage: emptyMessage,
    allowExclusions: true,
    isPreFiltered: searchValue !== (searchRef === null || searchRef === void 0 ? void 0 : searchRef.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }, (list, search) => {
    var _searchRef$getBoundin;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      panelPaddingSize: "none",
      isOpen: popoverIsOpen,
      display: 'block',
      button: search,
      closePopover: closePopover,
      style: {
        minWidth: 400
      },
      anchorPosition: "downLeft",
      ownFocus: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: (_searchRef$getBoundin = searchRef === null || searchRef === void 0 ? void 0 : searchRef.getBoundingClientRect().width) !== null && _searchRef$getBoundin !== void 0 ? _searchRef$getBoundin : 600,
        maxWidth: '100%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(PopOverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }), list, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        justifyContent: 'flex-end'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11ySelectableUrlListApplyButton",
      fill: true,
      size: "s",
      onClick: () => {
        onSelectionApply();
        closePopover();
      },
      isDisabled: !hasChanged(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.exploratoryView.apply.label', {
      defaultMessage: 'Apply'
    })))))));
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SelectableUrlList;