"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLControlsFlyout = ESQLControlsFlyout;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esqlTypes = require("@kbn/esql-types");
var _esqlUtils = require("@kbn/esql-utils");
var _value_control_form = require("./value_control_form");
var _shared_form_components = require("./shared_form_components");
var _identifier_control_form = require("./identifier_control_form");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/esql/public/triggers/esql_controls/control_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ESQLControlsFlyout({
  search,
  initialVariableType,
  queryString,
  esqlVariables,
  timeRange,
  onSaveControl,
  onCancelControl,
  cursorPosition,
  initialState,
  closeFlyout,
  ariaLabelledBy,
  currentApp
}) {
  var _initialState$control, _controlState$availab3;
  // ?? or ?
  const [variableNamePrefix, setVariableNamePrefix] = (0, _react.useState)((0, _helpers.getVariableNamePrefix)(initialVariableType));
  const valuesField = (0, _react.useMemo)(() => {
    if (initialVariableType === _esqlTypes.ESQLVariableType.VALUES) {
      return (0, _esqlUtils.getValuesFromQueryField)(queryString, cursorPosition);
    }
    return undefined;
  }, [cursorPosition, initialVariableType, queryString]);
  const isControlInEditMode = (0, _react.useMemo)(() => !!initialState, [initialState]);
  const suggestedVariableName = (0, _react.useMemo)(() => {
    const existingVariables = new Set(esqlVariables.filter(variable => variable.type === initialVariableType).map(variable => variable.key));
    if (initialState) {
      return `${variableNamePrefix}${initialState.variableName}`;
    }
    let variableNameSuggestion = (0, _helpers.getVariableSuggestion)(initialVariableType);
    if (valuesField && initialVariableType === _esqlTypes.ESQLVariableType.VALUES) {
      // variables names can't have special characters, only underscore
      const fieldVariableName = valuesField.replace(/[^a-zA-Z0-9]/g, '_');
      variableNameSuggestion = fieldVariableName;
    }
    return `${variableNamePrefix}${(0, _helpers.getRecurrentVariableName)(variableNameSuggestion, existingVariables)}`;
  }, [esqlVariables, initialState, valuesField, variableNamePrefix, initialVariableType]);
  const [controlFlyoutType, setControlFlyoutType] = (0, _react.useState)((_initialState$control = initialState === null || initialState === void 0 ? void 0 : initialState.controlType) !== null && _initialState$control !== void 0 ? _initialState$control : initialVariableType === _esqlTypes.ESQLVariableType.VALUES ? _esqlTypes.EsqlControlType.VALUES_FROM_QUERY : _esqlTypes.EsqlControlType.STATIC_VALUES);
  const [variableName, setVariableName] = (0, _react.useState)(suggestedVariableName);
  const [variableType, setVariableType] = (0, _react.useState)(initialVariableType);
  const [formIsInvalid, setFormIsInvalid] = (0, _react.useState)(false);
  const [controlState, setControlState] = (0, _react.useState)(initialState);
  const areValuesValid = (0, _react.useMemo)(() => {
    var _controlState$availab;
    const available = (_controlState$availab = controlState === null || controlState === void 0 ? void 0 : controlState.availableOptions) !== null && _controlState$availab !== void 0 ? _controlState$availab : [];
    return variableType === _esqlTypes.ESQLVariableType.TIME_LITERAL ? (0, _helpers.areValuesIntervalsValid)(available.map(option => option)) : true;
  }, [variableType, controlState === null || controlState === void 0 ? void 0 : controlState.availableOptions]);
  const onVariableNameChange = (0, _react.useCallback)(e => {
    const text = (0, _helpers.validateVariableName)(String(e.target.value), variableNamePrefix);
    setVariableName(text);
    const newType = (0, _helpers.getVariableTypeFromQuery)(text, variableType);
    setVariableType(newType);
    setVariableNamePrefix((0, _helpers.getVariableNamePrefix)(newType));
    if (controlFlyoutType === _esqlTypes.EsqlControlType.VALUES_FROM_QUERY && newType !== _esqlTypes.ESQLVariableType.VALUES) {
      setControlFlyoutType(_esqlTypes.EsqlControlType.STATIC_VALUES);
    }
  }, [controlFlyoutType, variableNamePrefix, variableType]);
  (0, _react.useEffect)(() => {
    var _controlState$availab2;
    const variableNameWithoutQuestionmark = variableName.replace(/^\?+/, '');
    const variableExists = (0, _helpers.checkVariableExistence)(esqlVariables, variableName) && !isControlInEditMode;
    setFormIsInvalid(!variableNameWithoutQuestionmark || variableExists || !areValuesValid || !(controlState !== null && controlState !== void 0 && (_controlState$availab2 = controlState.availableOptions) !== null && _controlState$availab2 !== void 0 && _controlState$availab2.length));
  }, [isControlInEditMode, areValuesValid, controlState === null || controlState === void 0 ? void 0 : (_controlState$availab3 = controlState.availableOptions) === null || _controlState$availab3 === void 0 ? void 0 : _controlState$availab3.length, esqlVariables, variableName, variableType]);
  const onFlyoutTypeChange = (0, _react.useCallback)(controlType => {
    setControlFlyoutType(controlType);
  }, []);
  const onCreateControl = (0, _react.useCallback)(async () => {
    var _controlState$availab4;
    if (controlState && (_controlState$availab4 = controlState.availableOptions) !== null && _controlState$availab4 !== void 0 && _controlState$availab4.length) {
      if (!isControlInEditMode) {
        if (cursorPosition) {
          const query = (0, _helpers.updateQueryStringWithVariable)(queryString, variableName, cursorPosition);
          await (onSaveControl === null || onSaveControl === void 0 ? void 0 : onSaveControl(controlState, query));
        } else {
          await (onSaveControl === null || onSaveControl === void 0 ? void 0 : onSaveControl(controlState, queryString));
        }
      } else {
        await (onSaveControl === null || onSaveControl === void 0 ? void 0 : onSaveControl(controlState, ''));
      }
    }
    closeFlyout();
  }, [controlState, closeFlyout, isControlInEditMode, cursorPosition, queryString, variableName, onSaveControl]);
  const formBody = variableNamePrefix === _esqlTypes.VariableNamePrefix.VALUE ? /*#__PURE__*/_react.default.createElement(_value_control_form.ValueControlForm, {
    queryString: queryString,
    variableName: variableName,
    controlFlyoutType: controlFlyoutType,
    variableType: variableType,
    initialState: initialState,
    setControlState: setControlState,
    search: search,
    valuesRetrieval: valuesField,
    timeRange: timeRange,
    currentApp: currentApp,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_identifier_control_form.IdentifierControlForm, {
    variableType: variableType,
    esqlVariables: esqlVariables,
    variableName: variableName,
    queryString: queryString,
    setControlState: setControlState,
    initialState: initialState,
    search: search,
    cursorPosition: cursorPosition,
    currentApp: currentApp,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_form_components.Header, {
    isInEditMode: isControlInEditMode,
    ariaLabelledBy: ariaLabelledBy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: _helpers.flyoutStyles,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_form_components.ControlType, {
    isDisabled: variableType !== _esqlTypes.ESQLVariableType.VALUES,
    initialControlFlyoutType: controlFlyoutType,
    onFlyoutTypeChange: onFlyoutTypeChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_form_components.VariableName, {
    variableName: variableName,
    isControlInEditMode: isControlInEditMode,
    onVariableNameChange: onVariableNameChange,
    esqlVariables: esqlVariables,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }), formBody), /*#__PURE__*/_react.default.createElement(_shared_form_components.Footer, {
    onCancelControl: onCancelControl,
    isSaveDisabled: formIsInvalid,
    closeFlyout: closeFlyout,
    onCreateControl: onCreateControl,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }));
}