"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../../complete_items");
var _shared = require("../../../definitions/utils/shared");
var _ = require("../..");
var _functions = require("../../../definitions/utils/autocomplete/functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// ToDo: this is hardcoded, we should find a better way to take care of the fork commands
const FORK_AVAILABLE_COMMANDS = ['limit', 'sort', 'where', 'dissect', 'stats', 'eval', 'completion', 'grok', 'change_point', 'mv_expand', 'keep', 'drop', 'rename', 'sample', 'join', 'enrich'];
async function autocomplete(query, command, callbacks, context, cursorPosition) {
  const innerText = query.substring(0, cursorPosition);
  if (/FORK\s+$/i.test(innerText)) {
    return [newBranchSuggestion];
  }
  const activeBranch = getActiveBranch(command);
  const withinActiveBranch = activeBranch && activeBranch.location.min <= innerText.length && activeBranch.location.max >= innerText.length;
  if (!withinActiveBranch && /\)\s+$/i.test(innerText)) {
    const suggestions = [newBranchSuggestion];
    if (command.args.length > 1) {
      suggestions.push(_complete_items.pipeCompleteItem);
    }
    return suggestions;
  }

  // within a branch
  if ((activeBranch === null || activeBranch === void 0 ? void 0 : activeBranch.commands.length) === 0 || (0, _shared.pipePrecedesCurrentWord)(innerText)) {
    return (0, _complete_items.getCommandAutocompleteDefinitions)(FORK_AVAILABLE_COMMANDS);
  }
  const subCommand = activeBranch === null || activeBranch === void 0 ? void 0 : activeBranch.commands[activeBranch.commands.length - 1];
  if (!subCommand) {
    return [];
  }
  const functionsSpecificSuggestions = await (0, _functions.getInsideFunctionsSuggestions)(innerText, cursorPosition, callbacks, context);
  if (functionsSpecificSuggestions) {
    return functionsSpecificSuggestions;
  }
  const subCommandMethods = _.esqlCommandRegistry.getCommandMethods(subCommand.name);
  return (subCommandMethods === null || subCommandMethods === void 0 ? void 0 : subCommandMethods.autocomplete(innerText, subCommand, callbacks, context)) || [];
}
const newBranchSuggestion = (0, _helpers.withAutoSuggest)({
  kind: 'Issue',
  label: _i18n.i18n.translate('kbn-esql-ast.esql.suggestions.newBranchLabel', {
    defaultMessage: 'New branch'
  }),
  detail: _i18n.i18n.translate('kbn-esql-ast.esql.suggestions.newBranchDetail', {
    defaultMessage: 'Add a new branch to the fork'
  }),
  text: '($0)',
  asSnippet: true
});
const getActiveBranch = command => {
  const finalBranch = command.args[command.args.length - 1];
  if (Array.isArray(finalBranch) || finalBranch.type !== 'query') {
    // should never happen
    return;
  }
  return finalBranch;
};