"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalFields = GlobalFields;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("../../../components");
var _hooks = require("../../hooks");
var _form = require("../form");
var _use_multi_fields = require("../use_multi_fields");
var _form_utils = require("./form_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/form_global_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// map of field ids to "<UseField />" props
const globalFields = {
  fieldA: {
    path: 'fieldA',
    defaultValue: 'foo',
    config: {
      label: 'Field A'
    }
  },
  fieldB: {
    path: 'fieldB',
    defaultValue: 123,
    config: {
      label: 'Field B'
    }
  }
};
const FormGlobalFieldsContext = /*#__PURE__*/(0, _react.createContext)({});
const useGlobalFields = () => {
  const ctx = (0, _react.useContext)(FormGlobalFieldsContext);
  if (!ctx) {
    throw new Error('Missing provider');
  }
  return ctx;
};
const FormGlobalFields = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_multi_fields.UseMultiFields, {
    fields: globalFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, fields => {
    return /*#__PURE__*/_react.default.createElement(FormGlobalFieldsContext.Provider, {
      value: fields,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, children);
  });
};
const FormFields = () => {
  const {
    fieldA,
    fieldB
  } = useGlobalFields();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.TextField, {
    field: fieldA,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_components.NumericField, {
    field: fieldB,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }));
};
function GlobalFields() {
  const {
    form
  } = (0, _hooks.useForm)();
  const [areFieldsVisible, setAreFieldsVisible] = (0, _react.useState)(true);
  const [areGlobalPresent, setAreGlobalPresent] = (0, _react.useState)(true);
  return /*#__PURE__*/_react.default.createElement(_form.Form, {
    form: form,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, areGlobalPresent && /*#__PURE__*/_react.default.createElement(FormGlobalFields, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, "You might need to have global fields in you form that persist their value event when a field unmounts. The recommended pattern is to use a React context along with \"UseMultiFields\""))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }), areFieldsVisible && /*#__PURE__*/_react.default.createElement(FormFields, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 32
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAreFieldsVisible(prev => !prev),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, "Toggle fields in DOM"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }, "Removing fields from DOM (that are connected to globals) will still preserve their value in the form.")))), /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setAreGlobalPresent(prev => !prev),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, "Toggle globals fields"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, "Removing the global fields from DOM remove their value when sending the form.")))), /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => (0, _form_utils.submitForm)(form),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, "Send form")));
}
GlobalFields.storyName = 'GlobalFields';
GlobalFields.parameters = {
  docs: {
    source: {
      code: `
// map of field ids to "<UseField />" props
const globalFields = {
  fieldA: {
    path: 'fieldA',
    defaultValue: 'foo',
    config: {
      label: 'Field A',
    },
  },
  fieldB: {
    path: 'fieldB',
    defaultValue: 123,
    config: {
      label: 'Field B',
    },
  },
};

const FormGlobalFieldsContext = createContext(
  {} as {
    fieldA: FieldHook<string>;
    fieldB: FieldHook<number>;
  }
);

const useGlobalFields = () => {
  const ctx = useContext(FormGlobalFieldsContext);
  if (!ctx) {
    throw new Error('Missing provider');
  }
  return ctx;
};

const FormGlobalFields: FC<PropsWithChildren<unknown>> = ({ children }) => {
  return (
    <UseMultiFields fields={globalFields}>
      {(fields) => {
        return (
          <FormGlobalFieldsContext.Provider value={fields}>
            {children}
          </FormGlobalFieldsContext.Provider>
        );
      }}
    </UseMultiFields>
  );
};

const FormFields = () => {
  const { fieldA, fieldB } = useGlobalFields();

  return (
    <>
      <TextField field={fieldA} />
      <NumericField field={fieldB} />
    </>
  );
};

const MyFormComponent = () => {
  const { form } = useForm();
  const [areFieldsVisible, setAreFieldsVisible] = useState(true);
  const [areGlobalPresent, setAreGlobalPresent] = useState(true);

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      {areGlobalPresent && (
        <FormGlobalFields>
          <EuiText>
            <p>
              <EuiTextColor color="subdued">
                You might need to have global fields in you form that persist their value event when
                a field unmounts. The recommended pattern is to use a React context along with
                &quot;UseMultiFields&quot;
              </EuiTextColor>
            </p>
          </EuiText>

          <EuiSpacer />

          {areFieldsVisible && <FormFields />}

          <EuiButton onClick={() => setAreFieldsVisible((prev) => !prev)}>
            Toggle fields in DOM
          </EuiButton>
          <EuiText size="s">
            <p>
              <EuiTextColor color="subdued">
                Removing fields from DOM (that are connected to globals) will still preserve their
                value in the form.
              </EuiTextColor>
            </p>
          </EuiText>
        </FormGlobalFields>
      )}
      <div>
        <EuiSpacer />
        <EuiButton onClick={() => setAreGlobalPresent((prev) => !prev)}>
          Toggle globals fields
        </EuiButton>
        <EuiText size="s">
          <p>
            <EuiTextColor color="subdued">
              Removing the global fields from DOM remove their value when sending the form.
            </EuiTextColor>
          </p>
        </EuiText>
      </div>

      <div>
        <EuiSpacer />
        <EuiButton onClick={submitForm}>Send form</EuiButton>
      </div>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};