"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _codeEditor = require("@kbn/code-editor");
var _use_json = require("./use_json");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/public/components/json_editor/json_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function JsonEditorComp({
  label,
  helpText,
  onUpdate,
  value,
  defaultValue,
  codeEditorProps,
  error: propsError,
  ...rest
}) {
  const {
    content,
    setContent,
    error: internalError,
    isControlled
  } = (0, _use_json.useJson)({
    defaultValue,
    onUpdate,
    value
  });
  const debouncedSetContent = (0, _react.useMemo)(() => {
    return (0, _lodash.debounce)(setContent, 300);
  }, [setContent]);

  // We let the consumer control the validation and the error message.
  const error = isControlled ? propsError : internalError;
  const onEuiCodeEditorChange = (0, _react.useCallback)(updated => {
    if (isControlled) {
      onUpdate({
        data: {
          raw: updated,
          format: () => JSON.parse(updated)
        },
        validate: () => {
          try {
            JSON.parse(updated);
            return true;
          } catch (e) {
            return false;
          }
        },
        isValid: undefined
      });
    } else {
      debouncedSetContent(updated);
    }
  }, [isControlled, debouncedSetContent, onUpdate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: label,
    helpText: helpText,
    isInvalid: typeof error === 'string',
    error: error,
    fullWidth: true
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, (0, _extends2.default)({
    languageId: "json",
    height: 500,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    value: isControlled ? value : content,
    onChange: onEuiCodeEditorChange
  }, codeEditorProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  })));
}
const JsonEditor = exports.JsonEditor = /*#__PURE__*/_react.default.memo(JsonEditorComp);