"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationIndicesFlyoutLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _fetch_search_application_api_logic = require("../../api/search_applications/fetch_search_application_api_logic");
var _search_application_view_logic = require("../search_application/search_application_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchApplicationIndicesFlyoutLogic = exports.SearchApplicationIndicesFlyoutLogic = (0, _kea.kea)({
  actions: {
    closeFlyout: true,
    openFlyout: name => ({
      name
    })
  },
  connect: {
    actions: [_search_application_view_logic.SearchApplicationViewLogic, ['fetchSearchApplication']],
    values: [_search_application_view_logic.SearchApplicationViewLogic, ['searchApplicationData', 'fetchSearchApplicationApiError', 'fetchSearchApplicationApiStatus']]
  },
  listeners: ({}) => ({
    openFlyout: async ({
      name
    }) => {
      _fetch_search_application_api_logic.FetchSearchApplicationApiLogic.actions.makeRequest({
        name
      });
    }
  }),
  path: ['enterprise_search', 'search_applications', 'search_application_indices_flyout_logic'],
  reducers: ({}) => ({
    isFlyoutVisible: [false, {
      closeFlyout: () => false,
      openFlyout: () => true
    }],
    searchApplicationName: [null, {
      closeFlyout: () => null,
      openFlyout: (_, {
        name
      }) => name
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    isSearchApplicationLoading: [() => [selectors.fetchSearchApplicationApiStatus], status => [_api.Status.LOADING].includes(status)]
  })
});