"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseCombinedOrThrow = void 0;
var _add_trailing_backticks_if_necessary = require("../add_trailing_backticks_if_necessary");
var _extract_json = require("../extract_json");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseCombinedOrThrow = ({
  combinedResponse,
  generationAttempts,
  llmType,
  logger,
  nodeName,
  generationSchema
}) => {
  const timestamp = new Date().toISOString();
  const extractedJson = (0, _extract_json.extractJson)((0, _add_trailing_backticks_if_necessary.addTrailingBackticksIfNecessary)(combinedResponse));
  logger === null || logger === void 0 ? void 0 : logger.debug(() => `${nodeName} node is parsing extractedJson (${llmType}) from attempt ${generationAttempts}`);
  const unvalidatedParsed = JSON.parse(extractedJson);
  logger === null || logger === void 0 ? void 0 : logger.debug(() => `${nodeName} node is validating combined response (${llmType}) from attempt ${generationAttempts}`);
  const validatedResponse = generationSchema.parse(unvalidatedParsed);
  logger === null || logger === void 0 ? void 0 : logger.debug(() => `${nodeName} node successfully validated insights response (${llmType}) from attempt ${generationAttempts}`);
  return [...validatedResponse.insights.map(insight => ({
    ...insight,
    timestamp
  }))];
};
exports.parseCombinedOrThrow = parseCombinedOrThrow;