"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFindAttackDiscoveryAlertsAggregation = void 0;
var _fields = require("../../schedules/fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Counts the unique alert IDs in attack discovery alerts
 */
const getFindAttackDiscoveryAlertsAggregation = (includeUniqueAlertIds = false) => ({
  api_config_name: {
    terms: {
      field: _fields.ALERT_ATTACK_DISCOVERY_API_CONFIG_NAME,
      // kibana.alert.attack_discovery.api_config.name
      size: 100 // up to 100 unique connector names
    }
  },
  unique_alert_ids_count: {
    cardinality: {
      field: 'kibana.alert.attack_discovery.alert_ids'
    }
  },
  ...(includeUniqueAlertIds ? {
    all_attack_alert_ids: {
      terms: {
        field: 'kibana.alert.attack_discovery.alert_ids',
        size: 10000 // up to 10,000 unique alert IDs
      }
    }
  } : {})
});
exports.getFindAttackDiscoveryAlertsAggregation = getFindAttackDiscoveryAlertsAggregation;