"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canPrependTimeFieldColumn = canPrependTimeFieldColumn;
exports.getVisibleColumns = getVisibleColumns;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function canPrependTimeFieldColumn(columns, timeFieldName, columnsMeta, showTimeCol,
// based on Advanced Settings `doc_table:hideTimeColumn`
isESQLMode) {
  if (!showTimeCol || !timeFieldName) {
    return false;
  }
  if (isESQLMode) {
    return !!columns && !!columnsMeta && timeFieldName in columnsMeta && columns.includes('_source');
  }
  return true;
}
function getVisibleColumns(columns, dataView, shouldPrependTimeFieldColumn) {
  const timeFieldName = dataView.timeFieldName;
  if (shouldPrependTimeFieldColumn && timeFieldName && !columns.find(col => col === timeFieldName)) {
    return [timeFieldName, ...columns];
  }
  return columns;
}