"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsQuerySearchAfter = getEsQuerySearchAfter;
var _context = require("../services/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the searchAfter query value for elasticsearch
 * When there are already documents available, which means successors or predecessors
 * were already fetched, the new searchAfter for the next fetch has to be the sort value
 * of the first (prececessor), or last (successor) of the list
 */
function getEsQuerySearchAfter(type, rows, anchor) {
  var _anchor$raw$sort, _anchor$raw$sort2;
  if (rows.length) {
    var _afterTimeDocRaw$sort, _afterTimeDocRaw$sort2;
    // already surrounding docs -> first or last record  is used
    const afterTimeRecIdx = type === _context.SurrDocType.SUCCESSORS && rows.length ? rows.length - 1 : 0;
    const afterTimeDocRaw = rows[afterTimeRecIdx].raw;
    return [(_afterTimeDocRaw$sort = afterTimeDocRaw.sort) === null || _afterTimeDocRaw$sort === void 0 ? void 0 : _afterTimeDocRaw$sort[0], (_afterTimeDocRaw$sort2 = afterTimeDocRaw.sort) === null || _afterTimeDocRaw$sort2 === void 0 ? void 0 : _afterTimeDocRaw$sort2[1]];
  }
  // ES search_after also works when number is provided as string
  return [(_anchor$raw$sort = anchor.raw.sort) === null || _anchor$raw$sort === void 0 ? void 0 : _anchor$raw$sort[0], (_anchor$raw$sort2 = anchor.raw.sort) === null || _anchor$raw$sort2 === void 0 ? void 0 : _anchor$raw$sort2[1]];
}