"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRuleParams = exports.RuleForm = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/stack-alerts-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _alertingComparators = require("@kbn/alerting-comparators");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _es_fields = require("../../../../common/es_fields");
var _utils = require("../../../utils");
var _rule_condition_chart = require("./rule_condition_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/rule_types/degraded_docs/rule_form/rule_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const degradedDocsLabel = _i18n.i18n.translate('xpack.datasetQuality.rule.degradedDocsLabel', {
  defaultMessage: 'degraded docs'
});
const defaultRuleParams = exports.defaultRuleParams = {
  comparator: _alertingComparators.COMPARATORS.GREATER_THAN,
  threshold: [3],
  timeSize: 5,
  timeUnit: 'm',
  groupBy: [_es_fields.INDEX]
};
const RuleForm = props => {
  var _defaultRuleParams$gr, _metadata$adHocDataVi, _ref;
  const {
    services: {
      dataViews,
      dataViewEditor
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    setRuleParams,
    ruleParams,
    errors,
    metadata,
    onChangeMetaData
  } = props;
  const {
    searchConfiguration,
    comparator,
    threshold,
    timeSize,
    timeUnit,
    groupBy
  } = ruleParams;
  const [dataView, setDataView] = (0, _react.useState)();
  const [dataViewError, setDataViewError] = (0, _react.useState)();
  const [preselectedOptions, _] = (0, _react.useState)((_defaultRuleParams$gr = defaultRuleParams.groupBy) !== null && _defaultRuleParams$gr !== void 0 ? _defaultRuleParams$gr : []);
  const [adHocDataViews, setAdHocDataViews] = (0, _react.useState)((_metadata$adHocDataVi = metadata === null || metadata === void 0 ? void 0 : metadata.adHocDataViewList) !== null && _metadata$adHocDataVi !== void 0 ? _metadata$adHocDataVi : []);
  const preFillProperty = (0, _react.useCallback)(property => {
    setRuleParams(property, defaultRuleParams[property]);
  }, [setRuleParams]);
  const updateProperty = (0, _react.useCallback)((property, value) => {
    setRuleParams(property, value);
  }, [setRuleParams]);
  (0, _react.useEffect)(() => {
    const initDataView = async () => {
      if (!(searchConfiguration !== null && searchConfiguration !== void 0 && searchConfiguration.index)) {
        setDataViewError(_i18n.i18n.translate('xpack.datasetQuality.rule.dataViewErrorNoTimestamp', {
          defaultMessage: 'A data view is required.'
        }));
        return;
      }
      if (searchConfiguration !== null && searchConfiguration !== void 0 && searchConfiguration.index && !dataView) {
        var _savedDataViews$find;
        const savedDataViews = await dataViews.getIdsWithTitle();
        const savedDataViewId = (_savedDataViews$find = savedDataViews.find(dv => dv.title === (searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.index))) === null || _savedDataViews$find === void 0 ? void 0 : _savedDataViews$find.id;
        if (savedDataViewId) {
          setDataView(await dataViews.get(savedDataViewId));
          return;
        }
        let currentDataView;
        const adHocDataView = adHocDataViews.find(dv => dv.title === (searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.index));
        if (adHocDataView) {
          currentDataView = adHocDataView;
        } else {
          currentDataView = await dataViews.create({
            title: searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.index,
            timeFieldName: '@timestamp'
          });
          setAdHocDataViews(prev => [...prev, currentDataView]);
        }
        setDataView(currentDataView);
      }
    };
    initDataView();
  }, [adHocDataViews, dataView, dataViews, searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.index]);
  (0, _react.useEffect)(() => {
    if (!comparator) {
      preFillProperty('comparator');
    }
    if (!threshold) {
      preFillProperty('threshold');
    }
    if (!timeSize) {
      preFillProperty('timeSize');
    }
    if (!timeUnit) {
      preFillProperty('timeUnit');
    }
    if (!groupBy) {
      preFillProperty('groupBy');
    }
  }, [preFillProperty, comparator, groupBy, threshold, timeSize, timeUnit]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    const gb = group ? (0, _lodash.isArray)(group) ? group : [group] : [];
    setRuleParams('groupBy', gb);
  }, [setRuleParams]);
  const derivedIndexPattern = (0, _react.useMemo)(() => ({
    fields: (dataView === null || dataView === void 0 ? void 0 : dataView.fields) || [],
    title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || 'unknown-index'
  }), [dataView]);
  const onSelectDataView = (0, _react.useCallback)(newDataView => {
    setDataViewError(undefined);
    updateProperty('searchConfiguration', {
      index: newDataView.getIndexPattern()
    });
    setDataView(newDataView);
  }, [updateProperty]);
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const gb = selectedOptions.map(option => option.label);
    onGroupByChange([...new Set(preselectedOptions.concat(gb))]);
  }, [onGroupByChange, preselectedOptions]);
  const getPreSelectedOptions = () => {
    return preselectedOptions.map(field => ({
      label: field,
      color: 'lightgray',
      disabled: true
    }));
  };
  const getUserSelectedOptions = group => {
    return (group !== null && group !== void 0 ? group : []).filter(g => !preselectedOptions.includes(g)).map(field => ({
      label: field
    }));
  };
  const selectedOptions = [...getPreSelectedOptions(), ...getUserSelectedOptions(groupBy)];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.rule.dataView",
    defaultMessage: "Select a data view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.DataViewSelectPopover, {
    dependencies: {
      dataViews,
      dataViewEditor
    },
    dataView: dataView,
    metadata: {
      adHocDataViewList: adHocDataViews
    },
    onSelectDataView: onSelectDataView,
    onChangeMetaData: ({
      adHocDataViewList
    }) => {
      onChangeMetaData({
        ...metadata,
        adHocDataViewList
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }), dataViewError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "datasetQualityRuleDataViewError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, dataViewError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.rule.alertCondition",
    defaultMessage: "Set rule conditions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    "data-test-subj": "datasetQualityRuleCountExpression",
    description: 'PERCENTAGE',
    value: degradedDocsLabel,
    display: "columns",
    onClick: () => {},
    disabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.ThresholdExpression, {
    thresholdComparator: comparator !== null && comparator !== void 0 ? comparator : defaultRuleParams.comparator,
    threshold: threshold,
    onChangeSelectedThresholdComparator: value => updateProperty('comparator', value),
    onChangeSelectedThreshold: value => updateProperty('threshold', value),
    errors: errors,
    display: "fullWidth",
    unit: '%',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_condition_chart.RuleConditionChart, {
    threshold: threshold,
    comparator: comparator,
    timeSize: timeSize,
    timeUnit: timeUnit,
    dataView: dataView,
    groupBy: groupBy,
    timeRange: {
      from: `now-${(timeSize !== null && timeSize !== void 0 ? timeSize : 1) * 20}${timeUnit}`,
      to: 'now'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    timeWindowSize: timeSize,
    timeWindowUnit: timeUnit,
    errors: {
      timeSize: [],
      timeUnit: []
    },
    onChangeWindowSize: value => updateProperty('timeSize', value),
    onChangeWindowUnit: value => updateProperty('timeUnit', value),
    display: "fullWidth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.datasetQuality.rule.createAlertPerText', {
      defaultMessage: 'Group alerts by (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.datasetQuality.rule.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "host.id" or "cloud.region".'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "datasetQualityRuleGroupBy",
    placeholder: _i18n.i18n.translate('xpack.datasetQuality.rule.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.datasetQuality.rule.groupByAriaLabel', {
      defaultMessage: 'Graph per'
    }),
    fullWidth: true,
    singleSelection: false,
    selectedOptions: selectedOptions,
    options: ((_ref = derivedIndexPattern.fields) !== null && _ref !== void 0 ? _ref : []).filter(f => f.aggregatable && f.type === 'string').map(f => ({
      label: f.name
    })),
    onChange: handleChange,
    isClearable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 9
    }
  })));
};
exports.RuleForm = RuleForm;