"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDeleteActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/actions/delete_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteConfirm = props => {
  const {
    searchSession,
    api,
    onActionDismiss
  } = props;
  const {
    name,
    id
  } = searchSession;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const bgsTitle = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.backgroundSearchTitle', {
    defaultMessage: 'Delete background search'
  });
  const confirm = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.deleteButton', {
    defaultMessage: 'Delete'
  });
  const cancel = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.cancelButton', {
    defaultMessage: 'Cancel'
  });
  const bgsMessage = _i18n.i18n.translate('data.mgmt.searchSessions.cancelModal.backgroundSearchMessage', {
    defaultMessage: `Deleting the background search ''{name}'' deletes all cached results.`,
    values: {
      name
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: bgsTitle,
    onCancel: onActionDismiss,
    onConfirm: async () => {
      setIsLoading(true);
      await api.sendDelete(id);
      onActionDismiss();
    },
    confirmButtonText: confirm,
    confirmButtonDisabled: isLoading,
    cancelButtonText: cancel,
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, bgsMessage);
};
const createDeleteActionDescriptor = (api, uiSession, core) => ({
  iconType: 'trash',
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.actionDelete",
    defaultMessage: "Delete",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 10
    }
  }),
  onClick: async () => {
    const ref = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(DeleteConfirm, {
      onActionDismiss: () => ref === null || ref === void 0 ? void 0 : ref.close(),
      searchSession: uiSession,
      api: api,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }), core));
    await ref.onClose;
  }
});
exports.createDeleteActionDescriptor = createDeleteActionDescriptor;