"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusText = exports.StatusIndicator = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _common = require("../../../../../common");
var _date_string = require("../lib/date_string");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// Shared helper function
const getStatusText = statusType => {
  switch (statusType) {
    case _common.SearchSessionStatus.IN_PROGRESS:
      return _i18n.i18n.translate('data.mgmt.searchSessions.status.label.inProgress', {
        defaultMessage: 'In progress'
      });
    case _common.SearchSessionStatus.EXPIRED:
      return _i18n.i18n.translate('data.mgmt.searchSessions.status.label.expired', {
        defaultMessage: 'Expired'
      });
    case _common.SearchSessionStatus.CANCELLED:
      return _i18n.i18n.translate('data.mgmt.searchSessions.status.label.cancelled', {
        defaultMessage: 'Cancelled'
      });
    case _common.SearchSessionStatus.COMPLETE:
      return _i18n.i18n.translate('data.mgmt.searchSessions.status.label.complete', {
        defaultMessage: 'Complete'
      });
    case _common.SearchSessionStatus.ERROR:
      return _i18n.i18n.translate('data.mgmt.searchSessions.status.label.error', {
        defaultMessage: 'Error'
      });
    default:
      // eslint-disable-next-line no-console
      console.error(`Unknown status ${statusType}`);
      return statusType;
  }
};
exports.getStatusText = getStatusText;
// Get the fields needed to show each status type
// can throw errors around date conversions
const getStatusAttributes = ({
  now,
  session,
  timezone
}) => {
  let expireDate;
  if (session.expires) {
    expireDate = (0, _date_string.dateString)(session.expires, timezone);
  } else {
    expireDate = _i18n.i18n.translate('data.mgmt.searchSessions.status.expireDateUnknown', {
      defaultMessage: 'unknown'
    });
  }
  switch (session.status) {
    case _common.SearchSessionStatus.IN_PROGRESS:
      try {
        return {
          textColor: 'default',
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 78,
              columnNumber: 17
            }
          }),
          label: /*#__PURE__*/_react.default.createElement(_.TableText, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 79,
              columnNumber: 18
            }
          }, getStatusText(session.status)),
          toolTipContent: _i18n.i18n.translate('data.mgmt.searchSessions.status.message.createdOn', {
            defaultMessage: 'Expires on {expireDate}',
            values: {
              expireDate
            }
          })
        };
      } catch (err) {
        // eslint-disable-next-line no-console
        console.error(err);
        throw new Error(`Could not instantiate a createdDate object from: ${session.created}`);
      }
    case _common.SearchSessionStatus.EXPIRED:
      try {
        const toolTipContent = _i18n.i18n.translate('data.mgmt.searchSessions.status.message.expiredOn', {
          defaultMessage: 'Expired on {expireDate}',
          values: {
            expireDate
          }
        });
        return {
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            color: "#9AA",
            type: "clock",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 99,
              columnNumber: 17
            }
          }),
          label: /*#__PURE__*/_react.default.createElement(_.TableText, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 100,
              columnNumber: 18
            }
          }, getStatusText(session.status)),
          toolTipContent
        };
      } catch (err) {
        // eslint-disable-next-line no-console
        console.error(err);
        throw new Error(`Could not instantiate an expiration Date object from: ${session.expires}`);
      }
    case _common.SearchSessionStatus.CANCELLED:
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "#9AA",
          type: "error",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 111,
            columnNumber: 15
          }
        }),
        label: /*#__PURE__*/_react.default.createElement(_.TableText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 16
          }
        }, getStatusText(session.status)),
        toolTipContent: _i18n.i18n.translate('data.mgmt.searchSessions.status.message.cancelled', {
          defaultMessage: 'Cancelled by user'
        })
      };
    case _common.SearchSessionStatus.ERROR:
      return {
        textColor: 'danger',
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "danger",
          type: "error",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 15
          }
        }),
        label: /*#__PURE__*/_react.default.createElement(_.TableText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 16
          }
        }, getStatusText(session.status)),
        toolTipContent: session.errors && session.errors.length > 0 ? _i18n.i18n.translate('data.mgmt.searchSessions.status.message.error', {
          defaultMessage: 'One or more searches failed to complete. Use the "Inspect" action to see the underlying errors.'
        }) : _i18n.i18n.translate('data.mgmt.searchSessions.status.message.unknownError', {
          defaultMessage: 'Unknown error'
        })
      };
    case _common.SearchSessionStatus.COMPLETE:
      try {
        const toolTipContent = _i18n.i18n.translate('data.mgmt.searchSessions.status.expiresOn', {
          defaultMessage: 'Expires on {expireDate}',
          values: {
            expireDate
          }
        });
        return {
          textColor: 'success',
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            color: "success",
            type: "checkInCircleFilled",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 143,
              columnNumber: 17
            }
          }),
          label: /*#__PURE__*/_react.default.createElement(_.TableText, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 144,
              columnNumber: 18
            }
          }, getStatusText(session.status)),
          toolTipContent
        };
      } catch (err) {
        // eslint-disable-next-line no-console
        console.error(err);
        throw new Error(`Could not instantiate an expiration Date object for completed session from: ${session.expires}`);
      }

      // Error was thrown
      return null;
    default:
      throw new Error(`Unknown status: ${session.status}`);
  }
};
const StatusIndicator = props => {
  try {
    const statusDef = getStatusAttributes(props);
    const {
      session
    } = props;
    if (statusDef) {
      const {
        toolTipContent
      } = statusDef;
      let icon = statusDef.icon;
      let label = statusDef.label;
      if (icon && toolTipContent) {
        icon = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: toolTipContent,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 16
          }
        }, icon);
      }
      if (toolTipContent) {
        label = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: toolTipContent,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 178,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_.TableText, {
          "data-test-subj": `sessionManagementStatusTooltip`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 179,
            columnNumber: 13
          }
        }, statusDef.label));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        css: iconCss,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 11
        }
      }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_.TableText, {
        color: statusDef.textColor,
        "data-test-subj": `sessionManagementStatusLabel`,
        "data-test-status": session.status,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 13
        }
      }, label)));
    }
  } catch (err) {
    // eslint-disable-next-line no-console
    console.error(err);
  }

  // Exception has been caught
  return /*#__PURE__*/_react.default.createElement(_.TableText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 10
    }
  }, props.session.status);
};
exports.StatusIndicator = StatusIndicator;
const iconCss = (0, _react2.css)`
  line-height: 1;
`;