"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InjectedMetadataService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Provides access to the metadata that is injected by the
 * server into the page. The metadata is actually defined
 * in the entry file for the bundle containing the new platform
 * and is read from the DOM in most cases.
 *
 * @internal
 */
class InjectedMetadataService {
  constructor(params) {
    (0, _defineProperty2.default)(this, "state", void 0);
    this.params = params;
    this.state = (0, _std.deepFreeze)(this.params.injectedMetadata);
  }
  start() {
    return this.setup();
  }
  setup() {
    return {
      getBasePath: () => {
        return this.state.basePath;
      },
      getServerBasePath: () => {
        return this.state.serverBasePath;
      },
      getPublicBaseUrl: () => {
        return this.state.publicBaseUrl;
      },
      getAssetsHrefBase: () => {
        return this.state.assetsHrefBase;
      },
      getAnonymousStatusPage: () => {
        return this.state.anonymousStatusPage;
      },
      getKibanaVersion: () => {
        return this.state.version;
      },
      getCspConfig: () => {
        return this.state.csp;
      },
      getExternalUrlConfig: () => {
        return this.state.externalUrl;
      },
      getPlugins: () => {
        return this.state.uiPlugins;
      },
      getLegacyMetadata: () => {
        return this.state.legacyMetadata;
      },
      getKibanaBuildNumber: () => {
        return this.state.buildNumber;
      },
      getKibanaBranch: () => {
        return this.state.branch;
      },
      getTheme: () => {
        return this.state.theme;
      },
      getElasticsearchInfo: () => {
        return this.state.clusterInfo;
      },
      getCustomBranding: () => {
        return this.state.customBranding;
      },
      getFeatureFlags: () => {
        return this.state.featureFlags;
      }
    };
  }
}
exports.InjectedMetadataService = InjectedMetadataService;