"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateStatus$ = void 0;
var _rxjs = require("rxjs");
var _coreStatusCommon = require("@kbn/core-status-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const calculateStatus$ = esNodesCompatibility$ => (0, _rxjs.merge)((0, _rxjs.of)({
  level: _coreStatusCommon.ServiceStatusLevels.unavailable,
  summary: `Waiting for Elasticsearch`,
  meta: {
    warningNodes: [],
    incompatibleNodes: []
  }
}), esNodesCompatibility$.pipe((0, _rxjs.map)(({
  isCompatible,
  message,
  incompatibleNodes,
  warningNodes,
  nodesInfoRequestError
}) => {
  if (!isCompatible) {
    return {
      level: _coreStatusCommon.ServiceStatusLevels.critical,
      summary: // Message should always be present, but this is a safe fallback
      message !== null && message !== void 0 ? message : `Some Elasticsearch nodes are not compatible with this version of Kibana`,
      meta: {
        warningNodes,
        incompatibleNodes,
        ...(nodesInfoRequestError && {
          nodesInfoRequestError
        })
      }
    };
  } else if (warningNodes.length > 0) {
    return {
      level: _coreStatusCommon.ServiceStatusLevels.available,
      summary: // Message should always be present, but this is a safe fallback
      message !== null && message !== void 0 ? message : `Some Elasticsearch nodes are running different versions than this version of Kibana`,
      meta: {
        warningNodes,
        incompatibleNodes
      }
    };
  }
  return {
    level: _coreStatusCommon.ServiceStatusLevels.available,
    summary: `Elasticsearch is available`,
    meta: {
      warningNodes: [],
      incompatibleNodes: []
    }
  };
})));
exports.calculateStatus$ = calculateStatus$;