"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCspBenchmarkIntegrationsV2 = exports.useCspBenchmarkIntegrationsV1 = exports.BENCHMARK_INTEGRATION_QUERY_KEY_V2 = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BENCHMARK_INTEGRATION_QUERY_KEY_V1 = 'csp_benchmark_integrations_v1';
const useCspBenchmarkIntegrationsV1 = ({
  name,
  perPage,
  page,
  sortField,
  sortOrder
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const query = {
    package_policy_name: name,
    per_page: perPage,
    page,
    sort_field: sortField,
    sort_order: sortOrder
  };
  return (0, _reactQuery.useQuery)([BENCHMARK_INTEGRATION_QUERY_KEY_V1, query], () => http.get(_constants.BENCHMARKS_ROUTE_PATH, {
    query,
    version: '1'
  }), {
    keepPreviousData: true
  });
};
exports.useCspBenchmarkIntegrationsV1 = useCspBenchmarkIntegrationsV1;
const BENCHMARK_INTEGRATION_QUERY_KEY_V2 = exports.BENCHMARK_INTEGRATION_QUERY_KEY_V2 = ['csp_benchmark_integrations_v2'];
const useCspBenchmarkIntegrationsV2 = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(BENCHMARK_INTEGRATION_QUERY_KEY_V2, () => http.get(_constants.BENCHMARKS_ROUTE_PATH, {
    version: '2'
  }), {
    keepPreviousData: true
  });
};
exports.useCspBenchmarkIntegrationsV2 = useCspBenchmarkIntegrationsV2;