"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappedColors = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _colors = require("../../static/colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Maintains a lookup table that associates the value (key) with a hex color (value)
 * across the visualizations.
 * Provides functions to interact with the lookup table
 */
class MappedColors {
  constructor(colorPaletteFn = _colors.createColorPalette) {
    (0, _defineProperty2.default)(this, "_mapping", void 0);
    this.colorPaletteFn = colorPaletteFn;
    this._mapping = {};
  }
  get mapping() {
    return this._mapping;
  }
  get(key) {
    return this._mapping[key];
  }
  mapKeys(keys) {
    const keysToMap = [];
    _lodash.default.each(keys, key => {
      // If this key isn't mapped, we need to map it
      if (this.get(key) == null) keysToMap.push(key);
    });

    // Generate a color palette big enough that all new keys can have unique color values
    const allColors = (0, _lodash.default)(this._mapping).values().value();
    const colorPalette = this.colorPaletteFn(allColors.length + keysToMap.length);
    let newColors = _lodash.default.difference(colorPalette, allColors);
    while (keysToMap.length > newColors.length) {
      newColors = newColors.concat(_lodash.default.sampleSize(allColors, keysToMap.length - newColors.length));
    }
    _lodash.default.merge(this._mapping, _lodash.default.zipObject(keysToMap, newColors));
  }
}
exports.MappedColors = MappedColors;