"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFeatureIds = void 0;
var _reactQuery = require("@kbn/react-query");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = require("react");
var _use_cases_toast = require("../common/use_cases_toast");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("./api");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformResponseToFeatureIds = data => {
  var _data$aggregations, _data$aggregations$co, _data$aggregations$co2, _data$aggregations2, _data$aggregations2$p, _data$aggregations2$p2, _data$aggregations$ru, _data$aggregations3, _data$aggregations3$r, _data$aggregations3$r2;
  const localFeatureIds = new Set();
  data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : (_data$aggregations$co = _data$aggregations.consumer) === null || _data$aggregations$co === void 0 ? void 0 : (_data$aggregations$co2 = _data$aggregations$co.buckets) === null || _data$aggregations$co2 === void 0 ? void 0 : _data$aggregations$co2.forEach(({
    key,
    doc_count: docCount
  }) => {
    if (docCount > 0 && (0, _ruleDataUtils.isValidFeatureId)(key)) {
      localFeatureIds.add(key);
    }
  });
  data === null || data === void 0 ? void 0 : (_data$aggregations2 = data.aggregations) === null || _data$aggregations2 === void 0 ? void 0 : (_data$aggregations2$p = _data$aggregations2.producer) === null || _data$aggregations2$p === void 0 ? void 0 : (_data$aggregations2$p2 = _data$aggregations2$p.buckets) === null || _data$aggregations2$p2 === void 0 ? void 0 : _data$aggregations2$p2.forEach(({
    key,
    doc_count: docCount
  }) => {
    if (docCount > 0 && (0, _ruleDataUtils.isValidFeatureId)(key)) {
      localFeatureIds.add(key);
    }
  });
  const ruleTypeIds = (_data$aggregations$ru = data === null || data === void 0 ? void 0 : (_data$aggregations3 = data.aggregations) === null || _data$aggregations3 === void 0 ? void 0 : (_data$aggregations3$r = _data$aggregations3.ruleTypeIds) === null || _data$aggregations3$r === void 0 ? void 0 : (_data$aggregations3$r2 = _data$aggregations3$r.buckets) === null || _data$aggregations3$r2 === void 0 ? void 0 : _data$aggregations3$r2.filter(({
    doc_count: docCount
  }) => docCount > 0).map(({
    key
  }) => key)) !== null && _data$aggregations$ru !== void 0 ? _data$aggregations$ru : [];
  return {
    featureIds: [...localFeatureIds],
    ruleTypeIds
  };
};
const useGetFeatureIds = (alertIds, enabled) => {
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  const {
    data,
    isInitialLoading,
    isLoading
  } = (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.alertFeatureIds(alertIds), ({
    signal
  }) => {
    return (0, _api.getFeatureIds)({
      query: {
        ids: {
          values: alertIds
        }
      },
      signal
    });
  }, {
    select: transformResponseToFeatureIds,
    enabled,
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_TITLE
      });
    }
  });
  return (0, _react.useMemo)(() => ({
    data,
    isLoading: (isInitialLoading || isLoading) && enabled
  }), [data, enabled, isInitialLoading, isLoading]);
};
exports.useGetFeatureIds = useGetFeatureIds;