"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileThumbnail = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _eui = require("@elastic/eui");
var _files = require("../../../common/files");
var _use_file_preview = require("./use_file_preview");
var _file_preview = require("./file_preview");
var _use_cases_context = require("../cases_context/use_cases_context");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/files/file_thumbnail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const componentStyle = {
  cursor: 'pointer'
};
const FileThumbnail = exports.FileThumbnail = /*#__PURE__*/_react.default.memo(props => {
  const {
    isPreviewVisible,
    showPreview,
    closePreview
  } = (0, _use_file_preview.useFilePreview)();
  const {
    client: filesClient
  } = (0, _sharedUxFileContext.useFilesContext)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  if (!(0, _utils.isValidFileExternalReferenceMetadata)(props.externalReferenceMetadata)) {
    // This check is done only for TS reasons, externalReferenceMetadata is always FileAttachmentMetadata
    return null;
  }
  const file = (0, _utils.getFileFromReferenceMetadata)({
    externalReferenceMetadata: props.externalReferenceMetadata,
    fileId: props.externalReferenceId
  });
  const imageUrl = filesClient.getDownloadHref({
    id: file.id,
    fileKind: (0, _files.constructFileKindIdByOwner)(owner[0])
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: imageUrl,
    alt: file.name,
    size: "s",
    "data-test-subj": "cases-files-image-thumbnail",
    onClick: showPreview,
    css: componentStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), isPreviewVisible && /*#__PURE__*/_react.default.createElement(_file_preview.FilePreview, {
    closePreview: closePreview,
    selectedFile: file,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 28
    }
  }));
});
FileThumbnail.displayName = 'FileThumbnail';