"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableFactory = exports.getTableRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _datatable = require("../../public/components/datatable");
var _i18n = require("../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  dropdownFilter: strings
} = _i18n.RendererStrings;
const getTableRenderer = core => () => ({
  name: 'table',
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render(domNode, config, handlers) {
    const {
      datatable,
      paginate,
      perPage,
      font = {
        spec: {}
      },
      showHeader
    } = config;
    _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        ...font.spec,
        height: '100%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_datatable.Datatable, {
      datatable: datatable,
      perPage: perPage,
      paginate: paginate,
      showHeader: showHeader,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 13
      }
    }))), domNode, () => handlers.done());
    handlers.onDestroy(() => _reactDom.default.unmountComponentAtNode(domNode));
  }
});
exports.getTableRenderer = getTableRenderer;
const tableFactory = (core, _plugins) => getTableRenderer(core);
exports.tableFactory = tableFactory;