"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleValidatePipeline = handleValidatePipeline;
var _pipeline = require("./pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleValidatePipeline({
  state,
  client
}) {
  const previousError = JSON.stringify(state.errors, null, 2);
  const results = await (0, _pipeline.testPipeline)(state.rawSamples, state.currentPipeline, client);
  return {
    errors: results.errors,
    previousError,
    previousPipelineResults: state.pipelineResults,
    pipelineResults: results.pipelineResults,
    lastExecutedChain: 'validate_pipeline'
  };
}