"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActions = exports.reducer = exports.initialState = exports.ActionsProvider = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = exports.initialState = {
  step: 1,
  connector: undefined,
  integrationSettings: undefined,
  isGenerating: false,
  showCelCreateFlyout: false,
  isFlyoutGenerating: false,
  result: undefined
};
const reducer = (state, action) => {
  switch (action.type) {
    case 'SET_STEP':
      return {
        ...state,
        step: action.payload,
        isGenerating: false,
        ...(action.payload < state.step && {
          result: undefined
        }) // reset the result when we go back
      };
    case 'SET_CONNECTOR':
      return {
        ...state,
        connector: action.payload
      };
    case 'SET_INTEGRATION_SETTINGS':
      return {
        ...state,
        integrationSettings: action.payload
      };
    case 'SET_IS_GENERATING':
      return {
        ...state,
        isGenerating: action.payload
      };
    case 'SET_SHOW_CEL_CREATE_FLYOUT':
      return {
        ...state,
        showCelCreateFlyout: action.payload
      };
    case 'SET_IS_FLYOUT_GENERATING':
      return {
        ...state,
        isFlyoutGenerating: action.payload
      };
    case 'SET_GENERATED_RESULT':
      return {
        ...state,
        // keep original result as the samplesFormat is not always included in the payload
        result: state.result ? {
          ...state.result,
          ...action.payload
        } : action.payload
      };
    case 'SET_CEL_INPUT_RESULT':
      return {
        ...state,
        celInputResult: action.payload
      };
    default:
      return state;
  }
};
exports.reducer = reducer;
const ActionsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const ActionsProvider = exports.ActionsProvider = ActionsContext.Provider;
const useActions = () => {
  const actions = (0, _react.useContext)(ActionsContext);
  if (!actions) {
    throw new Error('useActions must be used within a ActionsProvider');
  }
  return actions;
};
exports.useActions = useActions;