"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diagnosticsRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_diagnostics_bundle = require("./get_diagnostics_bundle");
var _get_fleet_package_info = require("./get_fleet_package_info");
var _get_exit_spans_from_samples = require("./service_map/get_exit_spans_from_samples");
var _get_trace_correlation = require("./service_map/get_trace_correlation");
var _default_api_types = require("../default_api_types");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _get_trace_sample_ids = require("../service_map/get_trace_sample_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getServiceMapDiagnosticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  endpoint: 'POST /internal/apm/diagnostics/service-map',
  params: t.type({
    body: t.intersection([_default_api_types.rangeRt, t.type({
      sourceNode: t.string,
      destinationNode: t.string
    }), t.partial({
      traceId: t.string
    })])
  }),
  handler: async resources => {
    var _destinationParentIds, _destinationParentIds2, _destinationParentIds3;
    const {
      start,
      end,
      destinationNode,
      traceId,
      sourceNode
    } = resources.params.body;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      traceIds
    } = await (0, _get_trace_sample_ids.getTraceSampleIds)({
      config: resources.config,
      apmEventClient,
      serviceName: sourceNode,
      environment: _environment_filter_values.ENVIRONMENT_ALL.value,
      start,
      end
    });
    const [sourceSpans, traceCorrelation] = await Promise.all([(0, _get_exit_spans_from_samples.getSourceSpanIds)({
      apmEventClient,
      start,
      end,
      sourceNode,
      traceIds
    }), (0, _get_trace_correlation.getTraceCorrelation)({
      apmEventClient,
      start,
      end,
      traceId,
      sourceNode,
      destinationNode
    })]);
    const [exitSpans, destinationParentIds] = await Promise.all([(0, _get_exit_spans_from_samples.getExitSpans)({
      apmEventClient,
      start,
      end,
      sourceNode,
      destinationNode,
      parentSpans: sourceSpans.destinationsBySpanId
    }), (0, _get_exit_spans_from_samples.getDestinationParentIds)({
      apmEventClient,
      start,
      end,
      parentSpans: sourceSpans.destinationsBySpanId,
      destinationNode
    })]);
    return {
      analysis: {
        exitSpans: {
          found: exitSpans.apmExitSpans.length > 0,
          totalConnections: exitSpans.totalConnections,
          apmExitSpans: exitSpans.apmExitSpans,
          hasMatchingDestinationResources: exitSpans.hasMatchingDestinationResources
        },
        parentRelationships: {
          found: destinationParentIds.hasParent,
          documentCount: ((_destinationParentIds = destinationParentIds.rawResponse) === null || _destinationParentIds === void 0 ? void 0 : (_destinationParentIds2 = _destinationParentIds.hits) === null || _destinationParentIds2 === void 0 ? void 0 : (_destinationParentIds3 = _destinationParentIds2.hits) === null || _destinationParentIds3 === void 0 ? void 0 : _destinationParentIds3.length) || 0,
          sourceSpanIds: [...sourceSpans.destinationsBySpanId.keys()]
        },
        ...(traceId && {
          traceCorrelation: {
            found: traceCorrelation === null || traceCorrelation === void 0 ? void 0 : traceCorrelation.foundInBothNodes,
            foundInSourceNode: traceCorrelation === null || traceCorrelation === void 0 ? void 0 : traceCorrelation.foundInSourceNode,
            foundInDestinationNode: traceCorrelation === null || traceCorrelation === void 0 ? void 0 : traceCorrelation.foundInDestinationNode,
            sourceNodeDocumentCount: traceCorrelation === null || traceCorrelation === void 0 ? void 0 : traceCorrelation.sourceNodeDocumentCount,
            destinationNodeDocumentCount: traceCorrelation === null || traceCorrelation === void 0 ? void 0 : traceCorrelation.destinationNodeDocumentCount
          }
        })
      },
      // Include raw Elasticsearch responses for debugging and advanced analysis
      elasticsearchResponses: {
        exitSpansQuery: exitSpans.rawResponse,
        sourceSpansQuery: sourceSpans.sourceSpanIdsRawResponse,
        destinationParentIdsQuery: destinationParentIds.rawResponse,
        ...(traceId && {
          traceCorrelationQuery: traceCorrelation === null || traceCorrelation === void 0 ? void 0 : traceCorrelation.rawResponse
        })
      }
    };
  }
});
const getDiagnosticsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/diagnostics',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  params: t.partial({
    query: t.partial({
      kuery: t.string,
      start: _ioTsUtils.isoToEpochRt,
      end: _ioTsUtils.isoToEpochRt
    })
  }),
  handler: async resources => {
    const {
      start,
      end,
      kuery
    } = resources.params.query;
    const coreContext = await resources.context.core;
    const apmIndices = await resources.getApmIndices();
    const {
      asCurrentUser: esClient
    } = coreContext.elasticsearch.client;
    const bundle = await (0, _get_diagnostics_bundle.getDiagnosticsBundle)({
      esClient,
      apmIndices,
      start,
      end,
      kuery
    });
    const fleetPackageInfo = await (0, _get_fleet_package_info.getFleetPackageInfo)(resources);
    const kibanaVersion = resources.kibanaVersion;
    return {
      ...bundle,
      fleetPackageInfo,
      kibanaVersion
    };
  }
});
const diagnosticsRepository = exports.diagnosticsRepository = {
  ...getDiagnosticsRoute,
  ...getServiceMapDiagnosticsRoute
};