"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformGetResponse = void 0;
var _transforms = require("../../../../rule/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformGetResponse = ruleTemplate => ({
  id: ruleTemplate.id,
  name: ruleTemplate.name,
  params: ruleTemplate.params,
  rule_type_id: ruleTemplate.ruleTypeId,
  schedule: ruleTemplate.schedule,
  tags: ruleTemplate.tags,
  ...(ruleTemplate.alertDelay ? {
    alert_delay: ruleTemplate.alertDelay
  } : {}),
  ...(ruleTemplate.flapping ? {
    flapping: (0, _transforms.transformFlappingV1)(ruleTemplate.flapping)
  } : {})
});
exports.transformGetResponse = transformGetResponse;