"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _create_maintenance_window = require("../application/maintenance_window/methods/create/create_maintenance_window");
var _get_maintenance_window = require("../application/maintenance_window/methods/get/get_maintenance_window");
var _update_maintenance_window = require("../application/maintenance_window/methods/update/update_maintenance_window");
var _find_maintenance_windows = require("../application/maintenance_window/methods/find/find_maintenance_windows");
var _delete_maintenance_window = require("../application/maintenance_window/methods/delete/delete_maintenance_window");
var _archive_maintenance_window = require("../application/maintenance_window/methods/archive/archive_maintenance_window");
var _get_active_maintenance_windows = require("../application/maintenance_window/methods/get_active/get_active_maintenance_windows");
var _finish_maintenance_window = require("../application/maintenance_window/methods/finish/finish_maintenance_window");
var _bulk_get_maintenance_windows = require("../application/maintenance_window/methods/bulk_get/bulk_get_maintenance_windows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MaintenanceWindowClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    (0, _defineProperty2.default)(this, "getUserName", void 0);
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "create", params => (0, _create_maintenance_window.createMaintenanceWindow)(this.context, params));
    (0, _defineProperty2.default)(this, "get", params => (0, _get_maintenance_window.getMaintenanceWindow)(this.context, params));
    (0, _defineProperty2.default)(this, "update", params => (0, _update_maintenance_window.updateMaintenanceWindow)(this.context, params));
    (0, _defineProperty2.default)(this, "find", params => (0, _find_maintenance_windows.findMaintenanceWindows)(this.context, params));
    (0, _defineProperty2.default)(this, "delete", params => (0, _delete_maintenance_window.deleteMaintenanceWindow)(this.context, params));
    (0, _defineProperty2.default)(this, "archive", params => (0, _archive_maintenance_window.archiveMaintenanceWindow)(this.context, params));
    (0, _defineProperty2.default)(this, "finish", params => (0, _finish_maintenance_window.finishMaintenanceWindow)(this.context, params));
    (0, _defineProperty2.default)(this, "bulkGet", params => (0, _bulk_get_maintenance_windows.bulkGetMaintenanceWindows)(this.context, params));
    (0, _defineProperty2.default)(this, "getActiveMaintenanceWindows", cacheIntervalMs => (0, _get_active_maintenance_windows.getActiveMaintenanceWindows)(this.context, cacheIntervalMs));
    this.logger = options.logger;
    this.savedObjectsClient = options.savedObjectsClient;
    this.getUserName = options.getUserName;
    this.context = {
      logger: this.logger,
      savedObjectsClient: this.savedObjectsClient,
      getModificationMetadata: this.getModificationMetadata.bind(this),
      uiSettings: options.uiSettings
    };
  }
  async getModificationMetadata() {
    const createTime = Date.now();
    const userName = await this.getUserName();
    return {
      createdBy: userName,
      updatedBy: userName,
      createdAt: new Date(createTime).toISOString(),
      updatedAt: new Date(createTime).toISOString()
    };
  }
}
exports.MaintenanceWindowClient = MaintenanceWindowClient;