"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allowedAppCategories = exports.AlertDeletionClient = exports.ALERT_DELETION_TASK_TYPE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_DELETION_TASK_TYPE = exports.ALERT_DELETION_TASK_TYPE = 'alert-deletion';
const allowedAppCategories = exports.allowedAppCategories = [_server.DEFAULT_APP_CATEGORIES.security.id, _server.DEFAULT_APP_CATEGORIES.management.id, _server.DEFAULT_APP_CATEGORIES.observability.id];
class AlertDeletionClient {
  constructor(opts) {
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "runTask", async (taskInstance, abortController) => {
      await (0, _lib.runTask)(this.context, taskInstance, abortController);
    });
    this.context = {
      auditService: opts.auditService,
      elasticsearchClientPromise: opts.elasticsearchClientPromise,
      eventLogger: opts.eventLogger,
      getAlertIndicesAlias: opts.getAlertIndicesAlias,
      logger: opts.logger.get(ALERT_DELETION_TASK_TYPE),
      ruleTypeRegistry: opts.ruleTypeRegistry,
      securityService: opts.securityService,
      spacesService: opts.spacesService,
      taskManagerStartPromise: opts.taskManagerStartPromise
    };

    // Registers the task that handles alert deletion
    opts.taskManagerSetup.registerTaskDefinitions({
      [ALERT_DELETION_TASK_TYPE]: {
        title: 'Alert deletion task',
        maxAttempts: 1,
        createTaskRunner: ({
          taskInstance,
          abortController
        }) => {
          return {
            run: async () => {
              return this.runTask(taskInstance, abortController);
            },
            cancel: async () => {}
          };
        }
      }
    });
  }
  async getLastRun(req) {
    return await (0, _lib.getLastRun)(this.context, req);
  }
  async scheduleTask(request, settings, spaceIds) {
    return await (0, _lib.scheduleTask)(this.context, request, settings, spaceIds);
  }
  async previewTask(settings, spaceId) {
    return await (0, _lib.previewTask)(this.context, settings, spaceId);
  }
}
exports.AlertDeletionClient = AlertDeletionClient;