"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPartitionScreenReaderDataSelector = void 0;
const geometries_1 = require("./geometries");
const get_partition_specs_1 = require("./get_partition_specs");
const create_selector_1 = require("../../../../state/create_selector");
const group_by_rollup_1 = require("../../layout/utils/group_by_rollup");
const getScreenReaderDataForPartitions = ([spec], shapeViewModels) => {
    return shapeViewModels.flatMap(({ quadViewModel, layers, panel }) => quadViewModel.map(({ depth, value, dataName, parent, path }) => {
        const label = layers[depth - 1]?.nodeLabel?.(dataName) ?? dataName;
        const parentValue = path.length > 1 ? path.at(-2)?.value : undefined;
        const parentName = depth > 1 && parentValue ? layers[depth - 2]?.nodeLabel?.(parentValue) ?? path.at(-1)?.value : 'none';
        return {
            panelTitle: panel.title,
            depth,
            label,
            parentName,
            percentage: `${Math.round((value / parent[group_by_rollup_1.STATISTICS_KEY].globalAggregate) * 100)}%`,
            value,
            valueText: spec?.valueFormatter ? spec.valueFormatter(value) : `${value}`,
        };
    }));
};
exports.getPartitionScreenReaderDataSelector = (0, create_selector_1.createCustomCachedSelector)([get_partition_specs_1.getPartitionSpecs, geometries_1.partitionMultiGeometries], (specs, shapeViewModel) => {
    if (specs.length === 0) {
        return {
            hasMultipleLayers: false,
            isSmallMultiple: false,
            data: [],
        };
    }
    return {
        hasMultipleLayers: (specs[0]?.layers.length ?? NaN) > 1,
        isSmallMultiple: shapeViewModel.length > 1,
        data: getScreenReaderDataForPartitions(specs, shapeViewModel),
    };
});
//# sourceMappingURL=get_screen_reader_data.js.map