"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsQualityIndicators = DatasetsQualityIndicators;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _hooks = require("../../../hooks");
var _translations = require("../../../../common/translations");
var _use_dataset_quality_filters = require("../../../hooks/use_dataset_quality_filters");
var _vertical_rule = require("../../common/vertical_rule");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/summary_panel/datasets_quality_indicators.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DatasetsQualityIndicators() {
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    timeRange
  } = (0, _use_dataset_quality_filters.useDatasetQualityFilters)();
  const {
    datasetsQuality,
    isDatasetsQualityLoading,
    numberOfDatasets,
    numberOfDocuments
  } = (0, _hooks.useSummaryPanelContext)();
  if (!isDatasetsQualityLoading && (numberOfDatasets || numberOfDocuments)) {
    onPageReady({
      customMetrics: {
        key1: 'datasets',
        value1: numberOfDatasets,
        key2: 'documents',
        value2: numberOfDocuments
      },
      meta: {
        rangeFrom: timeRange.from,
        rangeTo: timeRange.to,
        description: '[ttfmp_dataset_quality] The dataset quality has finished loading. Summary panel is showing the qualities categorized.'
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, _translations.summaryPanelQualityText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _translations.summaryPanelQualityTooltipText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(QualityIndicator, {
    value: datasetsQuality.poor,
    quality: "danger",
    description: _translations.summaryPanelQualityPoorText,
    isLoading: isDatasetsQualityLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_vertical_rule.VerticalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(QualityIndicator, {
    value: datasetsQuality.degraded,
    quality: "warning",
    description: _translations.summaryPanelQualityDegradedText,
    isLoading: isDatasetsQualityLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_vertical_rule.VerticalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(QualityIndicator, {
    value: datasetsQuality.good,
    quality: "success",
    description: _translations.summaryPanelQualityGoodText,
    isLoading: isDatasetsQualityLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))));
}
const QualityIndicator = ({
  value,
  quality,
  description,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": `datasetQualityDatasetHealthKpi-${description}`,
    textSize: "inherit",
    color: quality,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, value || 0))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: quality,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, description)));
};