"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fileUpload = require("@kbn/file-upload");
var _mappings = require("./file_status/mappings");
var _settings = require("./file_status/settings");
var _combined_fields = require("../../common/components/combined_fields");
var _create_data_view_tooltip = require("./create_data_view_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/advanced_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdvancedSection = ({
  canCreateDataView = true
}) => {
  var _mappings$json, _settings$json;
  const {
    filesStatus,
    fileUploadManager,
    pipelines,
    setDataViewName,
    indexName,
    mappings,
    settings,
    dataViewName,
    dataViewNameError,
    indexCreateMode
  } = (0, _fileUpload.useFileUploadContext)();
  const [combinedFields, setCombinedFields] = (0, _react.useState)([]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: 'advancedSection',
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedOptionsTitle",
      defaultMessage: "Advanced options",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }),
    paddingSize: "m",
    "data-test-subj": "dataVisualizerAdvancedSettingsAccordion",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SectionTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.mappingsTitle",
    defaultMessage: "Mappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_mappings.Mappings, {
    mappings: (_mappings$json = mappings === null || mappings === void 0 ? void 0 : mappings.json) !== null && _mappings$json !== void 0 ? _mappings$json : {},
    setMappings: m => fileUploadManager.updateMappings(m),
    showTitle: true,
    fileCount: filesStatus.length,
    showBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_combined_fields.CombinedFieldsForm, {
    mappings: mappings.json,
    onMappingsChange: m => fileUploadManager.updateMappings(m),
    pipelines: pipelines,
    onPipelinesChange: p => fileUploadManager.updatePipelines(p),
    combinedFields: combinedFields,
    onCombinedFieldsChange: f => setCombinedFields(f),
    isDisabled: false,
    filesStatus: filesStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), indexCreateMode === _fileUpload.UPLOAD_TYPE.NEW ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(SectionTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.dataViewTitle",
    defaultMessage: "Data view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_create_data_view_tooltip.CreateDataViewToolTip, {
    showTooltip: canCreateDataView === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "dataVisualizerCreateDataViewSwitch",
    id: "createDataView",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.createDataViewLabel",
      defaultMessage: "Create data view",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 17
      }
    }),
    checked: dataViewName === null ? false : true,
    disabled: canCreateDataView === false,
    onChange: e => setDataViewName(e.target.checked ? '' : null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.dataViewNameLabel",
      defaultMessage: "Data view name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.dataViewNameHelpText",
      defaultMessage: "By default data view will have the same name as the new index.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }),
    isInvalid: dataViewNameError !== '',
    error: [dataViewNameError],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "dataVisualizerDataViewNameInput",
    disabled: dataViewName === null,
    placeholder: dataViewName === null ? '' : indexName,
    value: dataViewName !== null && dataViewName !== void 0 ? dataViewName : '',
    onChange: e => setDataViewName(e.target.value),
    isInvalid: dataViewNameError !== '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(SectionTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.indexSettingsTitle",
    defaultMessage: "Index settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_settings.Settings, {
    settings: (_settings$json = settings === null || settings === void 0 ? void 0 : settings.json) !== null && _settings$json !== void 0 ? _settings$json : {},
    setSettings: s => fileUploadManager.updateSettings(s),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }));
};
exports.AdvancedSection = AdvancedSection;
const SectionTitle = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 160,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 161,
    columnNumber: 7
  }
}, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 164,
    columnNumber: 5
  }
}));