"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommonActions = void 0;
var _testUtils = require("react-dom/test-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getCommonActions = testBed => {
  const toggleFormRow = (row, value = 'on') => {
    const testSubj = `${row}Row.toggle`;
    const toggle = testBed.find(testSubj);
    const isOn = toggle.props()['aria-checked'];
    if (value === 'on' && isOn || value === 'off' && isOn === false) {
      return;
    }
    testBed.form.toggleEuiSwitch(testSubj);
  };
  const changeFieldType = async (value, label) => {
    await (0, _testUtils.act)(async () => {
      testBed.find('typeField').simulate('change', [{
        value,
        label: label !== null && label !== void 0 ? label : value
      }]);
    });
    testBed.component.update();
  };
  return {
    toggleFormRow,
    changeFieldType
  };
};
exports.getCommonActions = getCommonActions;