"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appIdColumn = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/columns/app_id.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// Helper function: translate an app string to EuiIcon-friendly string
const appToIcon = app => {
  if (app === 'dashboards') {
    return 'dashboard';
  }
  if (app === 'ml') {
    return 'machineLearning';
  }
  return app;
};

// Helper function: translate an app id to user friendly string
const appToTooltip = appId => {
  if (appId === 'ml') {
    return _i18n.i18n.translate('data.mgmt.searchSessions.table.mlAppName', {
      defaultMessage: 'Machine Learning'
    });
  }
};
const appIdColumn = exports.appIdColumn = {
  field: 'appId',
  name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerType', {
    defaultMessage: 'App'
  }),
  sortable: true,
  render: (appId, {
    id
  }) => {
    var _appToTooltip;
    const app = `${appToIcon(appId)}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: (_appToTooltip = appToTooltip(appId)) !== null && _appToTooltip !== void 0 ? _appToTooltip : (0, _lodash.capitalize)(app),
      type: `${app}App`,
      iconProps: {
        'data-test-subj': 'sessionManagementAppIcon'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    });
  }
};