"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setup = setup;
var _coreExecutionContextBrowserMocks = require("@kbn/core-execution-context-browser-mocks");
var _coreFatalErrorsBrowserMocks = require("@kbn/core-fatal-errors-browser-mocks");
var _coreInjectedMetadataBrowserMocks = require("@kbn/core-injected-metadata-browser-mocks");
var _coreHttpBrowserInternal = require("@kbn/core-http-browser-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultTap = injectedMetadata => {
  injectedMetadata.getBasePath.mockReturnValue('http://localhost/myBase');
};
function setup(tap = defaultTap) {
  const injectedMetadata = _coreInjectedMetadataBrowserMocks.injectedMetadataServiceMock.createSetupContract();
  const fatalErrors = _coreFatalErrorsBrowserMocks.fatalErrorsServiceMock.createSetupContract();
  tap(injectedMetadata, fatalErrors);
  const httpService = new _coreHttpBrowserInternal.HttpService();
  const executionContext = _coreExecutionContextBrowserMocks.executionContextServiceMock.createSetupContract();
  const http = httpService.setup({
    fatalErrors,
    injectedMetadata,
    executionContext
  });
  return {
    httpService,
    injectedMetadata,
    fatalErrors,
    http
  };
}