"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNotNull = exports.Match = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
var _duplicate_warning = require("./duplicate_warning");
var _utils = require("../../color/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/assignment/match.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const isNotNull = value => value !== null;
exports.isNotNull = isNotNull;
const Match = ({
  index,
  rules,
  updateRules,
  categories,
  specialTokens,
  formatter,
  allowCustomMatch = false,
  assignmentMatcher
}) => {
  const getOptionForRawValue = getOptionForRawValueFn(formatter);
  const availableOptions = [];

  // Map option key to their raw value
  const rawCategoryValueMap = categories.reduce((acc, value) => {
    const option = getOptionForRawValue(value);
    availableOptions.push(option);
    acc.set(option.key, value);
    return acc;
  }, new Map());
  const selectedOptions = rules.map(rule => {
    switch (rule.type) {
      case 'raw':
        {
          const rawValue = (0, _common.deserializeField)(rule.value);
          const hasDuplicate = assignmentMatcher.hasDuplicate(rawValue);
          const option = getOptionForRawValue(rule.value);
          rawCategoryValueMap.set(option.key, rule.value);
          return {
            ...option,
            append: hasDuplicate && /*#__PURE__*/_react.default.createElement(_duplicate_warning.DuplicateWarning, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 67,
                columnNumber: 37
              }
            })
          };
        }
      case 'match':
        {
          var _specialTokens$get;
          const key = rule.matchCase ? rule.pattern : rule.pattern.toLowerCase();
          const hasDuplicate = assignmentMatcher.hasDuplicate(key); // non-exhaustive for partial word match

          return {
            label: (_specialTokens$get = specialTokens.get(rule.pattern)) !== null && _specialTokens$get !== void 0 ? _specialTokens$get : rule.pattern,
            key: rule.pattern,
            append: hasDuplicate && /*#__PURE__*/_react.default.createElement(_duplicate_warning.DuplicateWarning, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 77,
                columnNumber: 37
              }
            })
          };
        }
      case 'regex':
        {
          // Note: Only basic placeholder logic, not used or fully tested
          const hasDuplicate = false; // need to use exhaustive search

          return {
            label: rule.pattern,
            key: rule.pattern,
            append: hasDuplicate && /*#__PURE__*/_react.default.createElement(_duplicate_warning.DuplicateWarning, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 87,
                columnNumber: 37
              }
            })
          };
        }
      default:
        return null;
    }
  }).filter(isNotNull);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 1,
      width: 1
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: true,
    "data-test-subj": `lns-colorMapping-assignmentsItem${index}`,
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.assignments.autoAssignedTermAriaLabel', {
      defaultMessage: "This color will be automatically assigned to the first term that doesn't match with all the other assignments"
    }),
    placeholder: _i18n.i18n.translate('coloring.colorMapping.assignments.autoAssignedTermPlaceholder', {
      defaultMessage: 'Auto assigning term'
    }),
    options: availableOptions,
    selectedOptions: selectedOptions,
    onChange: newOptions => {
      updateRules(newOptions.reduce((acc, {
        key = null
      }) => {
        if (key !== null) {
          if (rawCategoryValueMap.has(key)) {
            acc.push({
              type: 'raw',
              value: rawCategoryValueMap.get(key)
            });
          } else {
            acc.push({
              type: 'match',
              pattern: key,
              matchCase: true,
              matchEntireWord: true
            });
          }
        }
        return acc;
      }, []));
    },
    optionMatcher: ({
      option,
      normalizedSearchValue
    }) => {
      var _option$value;
      return String((_option$value = option.value) !== null && _option$value !== void 0 ? _option$value : '').includes(normalizedSearchValue) || option.label.includes(normalizedSearchValue);
    },
    onCreateOption: allowCustomMatch ? label => {
      return updateRules([...rules, {
        type: 'match',
        pattern: label,
        matchCase: true,
        matchEntireWord: true
      }]);
    } : undefined,
    isCaseSensitive: true,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
};
exports.Match = Match;
function getOptionForRawValueFn(fieldFormat) {
  var _fieldFormat$convert$;
  const formatter = (_fieldFormat$convert$ = fieldFormat === null || fieldFormat === void 0 ? void 0 : fieldFormat.convert.bind(fieldFormat)) !== null && _fieldFormat$convert$ !== void 0 ? _fieldFormat$convert$ : String;
  return serializedValue => {
    const rawValue = (0, _common.deserializeField)(serializedValue);
    const key = (0, _utils.getValueKey)(rawValue);
    return {
      key,
      value: typeof rawValue === 'number' ? key : undefined,
      label: formatter(rawValue)
    };
  };
}