"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _use_vulnerability_finding = require("@kbn/cloud-security-posture/src/hooks/use_vulnerability_finding");
var _findings_query_builders = require("@kbn/cloud-security-posture/src/utils/findings_query_builders");
var _create_detection_rule_from_vulnerability = require("../utils/create_detection_rule_from_vulnerability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilityFindingFlyout = ({
  vulnerabilityId,
  resourceId,
  packageName,
  packageVersion,
  eventId,
  children
}) => {
  var _data$result$hits$;
  const {
    data
  } = (0, _use_vulnerability_finding.useVulnerabilityFinding)({
    query: (0, _findings_query_builders.createGetVulnerabilityFindingsQuery)(vulnerabilityId, resourceId, packageName, packageVersion, eventId),
    enabled: true,
    pageSize: 1
  });
  const finding = data === null || data === void 0 ? void 0 : (_data$result$hits$ = data.result.hits[0]) === null || _data$result$hits$ === void 0 ? void 0 : _data$result$hits$._source;
  if (!finding) return null;
  return children({
    finding,
    createRuleFn: http => (0, _create_detection_rule_from_vulnerability.createDetectionRuleFromVulnerabilityFinding)(http, finding)
  });
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = VulnerabilityFindingFlyout;
module.exports = exports.default;